/* scmint.h -- SCM interface header */
#include <descrip.h>
#include "scm.h"

struct sit_quadword {
  unsigned long lo, hi;
};

#define SI_WNA "Wrong number of args: "
#define ARG6 "Wrong type in arg 6"
#define ARG7 "Wrong type in arg 7"
#define ARG8 "Wrong type in arg 8"
#define ARG9 "Wrong type in arg 9"
#define ARG10 "Wrong type in arg 10"
#define ARG11 "Wrong type in arg 11"
#define ARG12 "Wrong type in arg 12"
#define ARG13 "Wrong type in arg 13"
#define ARG14 "Wrong type in arg 14"
#define ARG15 "Wrong type in arg 15"


extern int si_booleanp (SCM);
extern int si_stringp (SCM);
extern int si_longwordp (SCM);
extern int si_unsigned_charp (SCM);
extern int si_doublep (SCM);
extern int si_floatp (SCM);
extern int si_unsigned_shortp (SCM);

extern long si_to_longword (SCM);
extern struct sit_quadword si_to_quadword (SCM);
extern unsigned char si_to_unsigned_char (SCM);
extern struct dsc$descriptor_s si_to_string (SCM);
extern unsigned short si_to_unsigned_short (SCM);

extern SCM si_from_longword (long);
extern SCM si_from_quadword (struct sit_quadword);
extern SCM si_from_unsigned_char (unsigned char);
extern SCM si_from_string (struct dsc$descriptor_s);
extern SCM si_from_unsigned_short (unsigned short);
