# Canvas chapter
proc LabeledEntrySetup { top title labels } {
	# Create a resizable toplevel window
	toplevel $top
	wm minsize $top 200 100
	wm title $top $title

	# Create a frame for buttons,
	# Only Dismiss does anything useful
	set f [frame $top.buttons -bd 4]
	button $f.quit -text Dismiss -command [list destroy $top]
	button $f.save -text Save
	button $f.reset -text Reset
	pack $f.quit $f.save $f.reset -side right
	pack $f -side top -fill x

	# Create a scrollable canvas
	frame $top.c
	canvas $top.c.canvas  -width 10 -height 10 \
		-yscrollcommand [list $top.c.yscroll set]
	scrollbar $top.c.yscroll -orient vertical  \
		-command [list $top.c.canvas yview]
	pack $top.c.yscroll -side right -fill y
	pack $top.c.canvas -side left -fill both -expand true
	pack $top.c -side top -fill both -expand true

	SetOfLabeledEntries $top.c.canvas $labels
}
proc SetOfLabeledEntries { canvas labels } {
	# Create one frame to hold everything
	# and position it on the canvas
	set f [frame $canvas.f -bd 0]
	$canvas create window 0 0 -anchor nw -window $f

	# Find out how big the labels are
	set max 0
	foreach label $labels {
		set len [string length $label]
		if {$len > $max} {
			set max $len
		}
	}
	# Create and pack the labeled entries
	set i 0
	foreach label $labels {
		frame $f.$i
		label $f.$i.label -text $label -width $max
		entry $f.$i.entry
		pack $f.$i.label -side left
		pack $f.$i.entry -side right -fill x
		pack $f.$i -side top -fill x
		incr i
	}
	set child [lindex [pack slaves $f] 0]
    
	# Wait for the window to become visible and then
	# set up the scroll region and increment based on
	# the size of the frame and the subframes
    
	tkwait visibility $child
	set incr [winfo height $child]
	set width [winfo width $f]
	set height [winfo height $f]
	$canvas config -scrollregion "0 0 $width $height"
	$canvas config -yscrollincrement $incr
	if {$height > 4 * $incr} {
		set height [expr 4 * $incr]
	}
	$canvas config -width $width -height $height
}
LabeledEntrySetup .greek "Greek Alphabet" \
 {alpha beta gamma delta epsilon zeta eta theta iota kappa
 lambda mu nu xi omicron pi rho sigma tau upsilon
 phi chi psi omega}
