# Listbox chapter
proc ScrolledListbox2 { parent args } {
	frame $parent
	# Create listbox attached to scrollbars, pass thru $args
	eval {listbox $parent.list \
		-yscrollcommand [list $parent.sy set] \
		-xscrollcommand [list $parent.sx set]} $args
	scrollbar $parent.sy -orient vertical \
		-command [list $parent.list yview]
	# Create extra frame to hold pad and horizontal scrollbar
	frame $parent.bottom
	scrollbar $parent.sx -orient horizontal \
		-command [list $parent.list xview]
	# Create padding based on the scrollbar width and border
	set pad [expr [$parent.sy cget -width] + 2* \
		([$parent.sy cget -bd] + \
		 [$parent.sy cget -highlightthickness])]
	frame $parent.pad -width $pad -height $pad
	# Arrange everything in the parent frame
	pack $parent.bottom -side bottom -fill x
	pack $parent.pad -in $parent.bottom -side right
	pack $parent.sx -in $parent.bottom -side bottom -fill x
	pack $parent.sy -side right -fill y
	pack $parent.list -side left -fill both -expand true
	return $parent.list
}
if 0 {
	frame $parent
	eval {listbox $parent.list \
		-yscrollcommand [list $parent.sy set] \
		-xscrollcommand [list $parent.pad.sx set]} $args
	scrollbar $parent.sy -orient vertical \
		-command [list $parent.list yview]
	# Create extra frame to hold pad and horizontal scrollbar
	frame $parent.pad
	scrollbar $parent.pad.sx -orient horizontal \
		-command [list $parent.list xview]
	# Create padding based on the scrollbar's width
	set pad [expr [$parent.sy cget -width] + \
	    2*([$parent.sy cget -bd] + [$parent.sy cget -highlightthickness])]
	frame $parent.pad.it -width $pad -height $pad
	# Arrange everything in the parent frame
	pack $parent.pad -side bottom -fill x
	pack $parent.pad.it -side right
	pack $parent.pad.sx -side bottom -fill x
	pack $parent.sy -side right -fill y
	pack $parent.list -side left -fill both -expand true
}
