/*
 * setuid.c
 * The setuid Tcl command.
 */

#include <tcl.h>
#include <sys/types.h>
#ifdef __WIN32__
#include <sys/utime.h>
#else
#include <utime.h>
#endif

/*
 * UtimeCmd --
 *	Change file access and modification times.
 *
 * Results:
 *	none
 *
 * Side Effects:
 *	Change access and modification times.
 */
int
UtimeObjCmd(ClientData data, Tcl_Interp *interp, int objc, Tcl_Obj * CONST objv[])
{
    struct utimbuf u = {0, 0};
    char *arg;

    if (objc > 3 && Tcl_GetIntFromObj(interp, objv[3], &u.actime)) {
	return TCL_ERROR;
    }
    if (objc > 2 && Tcl_GetIntFromObj(interp, objv[2], &u.modtime)) {
	return TCL_ERROR;
    }
    if (objc > 4 || objc <= 1) {
	Tcl_WrongNumArgs(interp, 1, objv, "file ?modtime? ?actime?");
	return TCL_ERROR;
    }
    arg = Tcl_GetStringFromObj(objv[1], NULL);
    if (utime(arg, &u) < 0) {
	Tcl_AppendResult(interp, "utime: ", arg, Tcl_PosixError(interp), NULL);
	return TCL_ERROR;
    }
    return TCL_OK;
}

/*
 * Utime_Init --
 *	Initialize the Tcl utime facility.
 *
 * Results:
 *	TCL_OK.
 *
 * Side Effects:
 *	None.
 */
int
Utime_Init(Tcl_Interp *interp)
{
    if (Tcl_PkgRequire(interp, "Tcl", "8", 0) == NULL) {
	return TCL_ERROR;
    }
    Tcl_CreateObjCommand(interp, "utime", UtimeObjCmd, NULL, NULL);
    return Tcl_PkgProvide(interp, "utime", "1.0");
}
