'\" -*- tcl -*- doctools manpage
'\"
'\" Generated from ../tcllib/modules/ncgi/ncgi.man by mpexpand with fmt.nroff
'\"
.so man.macros
.TH "ncgi" n 1.2.1 ncgi "CGI Support"
.BS
.SH NAME
ncgi \- Procedures to manipulate CGI values.
.SH "SYNOPSIS"
package require \fBTcl 8.2\fR
.sp
package require \fBncgi ?1.2.1?\fR
.sp
\fB::ncgi::cookie\fR \fIcookie\fR\fR
.sp
\fB::ncgi::decode\fR \fIstr\fR\fR
.sp
\fB::ncgi::empty\fR \fIname\fR\fR
.sp
\fB::ncgi::encode\fR \fIstring\fR\fR
.sp
\fB::ncgi::header\fR ?\fItype\fR? \fIargs\fR\fR
.sp
\fB::ncgi::import\fR \fIcginame\fR ?\fItclname\fR?\fR
.sp
\fB::ncgi::importAll\fR \fIargs\fR\fR
.sp
\fB::ncgi::input\fR ?\fIfakeinput\fR? ?\fIfakecookie\fR?\fR
.sp
\fB::ncgi::multipart\fR \fItype query\fR\fR
.sp
\fB::ncgi::nvlist\fR \fR
.sp
\fB::ncgi::parse\fR \fR
.sp
\fB::ncgi::parseMimeValue\fR \fIvalue\fR\fR
.sp
\fB::ncgi::query\fR \fR
.sp
\fB::ncgi::redirect\fR \fIurl\fR\fR
.sp
\fB::ncgi::reset\fR \fIquery type\fR\fR
.sp
\fB::ncgi::setCookie\fR \fIargs\fR\fR
.sp
\fB::ncgi::setDefaultValue\fR \fIkey defvalue\fR\fR
.sp
\fB::ncgi::setDefaultValueList\fR \fIkey defvaluelist\fR\fR
.sp
\fB::ncgi::setValue\fR \fIkey value\fR\fR
.sp
\fB::ncgi::setValueList\fR \fIkey valuelist\fR\fR
.sp
\fB::ncgi::type\fR \fR
.sp
\fB::ncgi::urlStub\fR ?\fIurl\fR?\fR
.sp
\fB::ncgi::value\fR \fIkey\fR ?\fIdefault\fR?\fR
.sp
\fB::ncgi::valueList\fR \fIkey\fR ?\fIdefault\fR?\fR
.sp
.BE
.SH "DESCRIPTION"
.PP
The \fBncgi\fR package provides commands that manipulate CGI
values.  These are values that come from Web forms and are processed
either by CGI scripts or web pages with embedded Tcl code.  Use the
\fBncgi\fR package to query these values, set and get cookies, and
encode and decode www-url-encoded values.
.PP
In the simplest case, a CGI script first calls \fB::ncgi::parse\fR and
then calls \fB::ncgi::value\fR to get different form values.  If a CGI
value is repeated, you should use \fB::ncgi::valueList\fR to get back
the complete list of values.
.PP
An alternative to \fB::ncgi::parse\fR is \fB::ncgi::input\fR, which
has semantics similar to Don Libes' \fBcgi_input\fR procedure.
\fB::ncgi::input\fR restricts repeated CGI values to have names that
end with "List".  In this case, \fB::ncgi::value\fR will return the
complete list of values, and \fB::ncgi::input\fR will raise errors if
it find repeated form elements without the right name.
.PP
The \fB::ncgi::reset\fR procedure can be used in test suites and Web
servers to initialize the source of the CGI values.  Otherwise the
values are read in from the CGI environment.
.PP
The complete set of procedures is described below.
.TP
\fB::ncgi::cookie\fR \fIcookie\fR\fR
Return a list of values for \fIcookie\fR, if any.  It is possible that
more than one cookie with the same name can be present, so this
procedure returns a list.
.TP
\fB::ncgi::decode\fR \fIstr\fR\fR
Decode strings in www-url-encoding, which represents special
characters with a %xx sequence, where xx is the character code in hex.
.TP
\fB::ncgi::empty\fR \fIname\fR\fR
Returns 1 if the CGI variable \fIname\fR is not present or has the
empty string as its value.
.TP
\fB::ncgi::encode\fR \fIstring\fR\fR
Encode \fIstring\fR into www-url-encoded format.
.TP
\fB::ncgi::header\fR ?\fItype\fR? \fIargs\fR\fR
Output the CGI header to standard output.  This emits a Content-Type:
header and additional headers based on \fIargs\fR, which is a list of
header names and header values. The \fItype\fR defaults to
"text/html".
.TP
\fB::ncgi::import\fR \fIcginame\fR ?\fItclname\fR?\fR
This creates a variable in the current scope with the value of the CGI
variable \fIcginame\fR.  The name of the variable is \fItclname\fR, or
\fIcginame\fR if \fItclname\fR is empty (default).
.TP
\fB::ncgi::importAll\fR \fIargs\fR\fR
This imports several CGI variables as Tcl variables.  If \fIargs\fR is
empty, then every CGI vale is imported.  Otherwise each CGI variable
listed in \fIargs\fR is imported.
.TP
\fB::ncgi::input\fR ?\fIfakeinput\fR? ?\fIfakecookie\fR?\fR
This reads and decodes the CGI values from the environment.  It
restricts repeated form values to have a trailing "List" in their
name.  The CGI values are obtained later with the \fB::ncgi::value\fR
procedure.
.TP
\fB::ncgi::multipart\fR \fItype query\fR\fR
This procedure parses a multipart/form-data \fIquery\fR.  This is used
by \fB::ncgi::nvlist\fR and not normally called directly.  It returns
an alternating list of names and structured values.  Each structure
value is in turn a list of two elements.  The first element is
meta-data from the multipart/form-data structure.  The second element
is the form value.  If you use \fB::ncgi::value\fR you just get the
form value.  If you use \fB::ncgi::valueList\fR you get the structured
value with meta data and the value.
.sp
The \fItype\fR is the whole Content-Type, including the parameters
like \fIboundary\fR.  This returns a list of names and values that
describe the multipart data.  The values are a nested list structure
that has some descriptive information first, and the actual form value
second.  The descriptive information is list of header names and
values that describe the content.
.TP
\fB::ncgi::nvlist\fR \fR
This returns all the query data as a name, value list.  In the case of
multipart/form-data, the values are structured as described in
\fB::ncgi::multipart\fR.
.TP
\fB::ncgi::parse\fR \fR
This reads and decodes the CGI values from the environment.  The CGI
values are obtained later with the \fB::ncgi::value\fR procedure.  IF
a CGI value is repeated, then you should use \fB::ncgi::valueList\fR
to get the complete list of values.
.TP
\fB::ncgi::parseMimeValue\fR \fIvalue\fR\fR
This decodes the Content-Type and other MIME headers that have the
form of "primary value; param=val; p2=v2" It returns a list, where the
first element is the primary value, and the second element is a list
of parameter names and values.
.TP
\fB::ncgi::query\fR \fR
This returns the raw query data.
.TP
\fB::ncgi::redirect\fR \fIurl\fR\fR
Generate a response that causes a 302 redirect by the Web server.  The
\fIurl\fR is the new URL that is the target of the redirect.  The URL
will be qualified with the current server and current directory, if
necessary, to convert it into a full URL.
.TP
\fB::ncgi::reset\fR \fIquery type\fR\fR
Set the query data and Content-Type for the current CGI session.  This
is used by the test suite and by Web servers to initialize the ncgi
module so it does not try to read standard input or use environment
variables to get its data.  If neither \fIquery\fR or \fItype\fR are
specified, then the \fBncgi\fR module will look in the standard
CGI environment for its data.
.TP
\fB::ncgi::setCookie\fR \fIargs\fR\fR
Set a cookie value that will be returned as part of the reply.  This
must be done before \fB::ncgi::header\fR or \fB::ncgi::redirect\fR is
called in order for the cookie to be returned properly.  The
\fIargs\fR are a set of flags and values:
.RS
.TP
\fB-name\fR \fIname\fR
.TP
\fB-value\fR \fIvalue\fR
.TP
\fB-expires\fR \fIdate\fR
.TP
\fB-path\fR \fIpath restriction\fR
.TP
\fB-domain\fR \fIdomain restriction\fR
.RE
.TP
\fB::ncgi::setDefaultValue\fR \fIkey defvalue\fR\fR
Set a CGI value if it does not already exists.  This affects future
calls to \fB::ncgi::value\fR (but not future calls to
\fB::ncgi::nvlist\fR).  If the CGI value already is present, then this
procedure has no side effects.
.TP
\fB::ncgi::setDefaultValueList\fR \fIkey defvaluelist\fR\fR
Like \fB::ncgi::setDefaultValue\fR except that the value already has
list structure to represent multiple checkboxes or a multi-selection.
.TP
\fB::ncgi::setValue\fR \fIkey value\fR\fR
Set a CGI value, overriding whatever was present in the CGI
environment already.  This affects future calls to \fB::ncgi::value\fR
(but not future calls to \fB::ncgi::nvlist\fR).
.TP
\fB::ncgi::setValueList\fR \fIkey valuelist\fR\fR
Like \fB::ncgi::setValue\fR except that the value already has list
structure to represent multiple checkboxes or a multi-selection.
.TP
\fB::ncgi::type\fR \fR
Returns the Content-Type of the current CGI values.
.TP
\fB::ncgi::urlStub\fR ?\fIurl\fR?\fR
Returns the current URL, but without the protocol, server, and port.
If \fIurl\fR is specified, then it defines the URL for the current
session.  That value will be returned by future calls to
\fB::ncgi::urlStub\fR
.TP
\fB::ncgi::value\fR \fIkey\fR ?\fIdefault\fR?\fR
Return the CGI value identified by \fIkey\fR.  If the CGI value is not
present, then the \fIdefault\fR value is returned instead. This value
defaults to the empty string.
.sp
If the form value \fIkey\fR is repeated, then there are two cases: if
\fB::ncgi::parse\fR was called, then \fB::ncgi::value\fR only returns
the first value associated with \fIkey\fR.  If \fB::ncgi::input\fR was
called, then \fB::ncgi::value\fR returns a Tcl list value and
\fIkey\fR must end in "List" (e.g., "skuList").  In the case of
multipart/form-data, this procedure just returns the value of the form
element.  If you want the meta-data associated with each form value,
then use \fB::ncgi::valueList\fR.
.TP
\fB::ncgi::valueList\fR \fIkey\fR ?\fIdefault\fR?\fR
Like \fB::ncgi::value\fR, but this always returns a list of values
(even if there is only one value).  In the case of
multipart/form-data, this procedure returns a list of two elements.
The first element is meta-data in the form of a parameter, value list.
The second element is the form value.
.SH "SEE ALSO"
html
.SH "KEYWORDS"
CGI, form, html, cookie
