[manpage_begin csv n 0.3]
[moddesc   {CSV processing}]
[titledesc {Procedures to handle CSV data.}]
[require Tcl 8.3]
[require csv [opt 0.3]]
[description]

[para]

The [strong csv] package provides commands to manipulate information
in CSV [strong FORMAT] (CSV = Comma Separated Values).

[section COMMANDS]
[para]

The following commands are available:

[list_begin definitions]

[call [cmd ::csv::join] [arg values] "{[arg sepChar] ,}"]

Takes a list of values and returns a string in CSV format containing
these values. The separator character can be defined by the caller,
but this is optional. The default is ",".

[call [cmd ::csv::joinlist] [arg values] "{[arg sepChar] ,}"]

Takes a list of lists of values and returns a string in CSV format
containing these values. The separator character can be defined by the
caller, but this is optional. The default is ",". Each element of the
outer list is considered a record, these are separated by newlines in
the result. The elements of each record are formatted as usual (via
[cmd ::csv::join]).

[call [cmd ::csv::read2matrix] [arg "chan m"] "{[arg sepChar] ,} {[arg expand] none}"]

A wrapper around [cmd ::csv::split2matrix] (see below) reading
CSV-formatted lines from the specified channel (until EOF) and adding
them to the given matrix. For an explanation of the [arg expand]
argument see [cmd ::csv::split2matrix].

[call [cmd ::csv::read2queue] [arg "chan q"] "{[arg sepChar] ,}"]

A wrapper around [cmd ::csv::split2queue] (see below) reading
CSV-formatted lines from the specified channel (until EOF) and adding
them to the given queue.

[call [cmd ::csv::report] [arg "cmd matrix"] [opt [arg chan]]]

A report command which can be used by the matrix methods

[cmd "format 2string"] and [cmd "format 2chan"]. For the latter this
command delegates the work to [cmd ::csv::writematrix]. [arg cmd] is
expected to be either [strong printmatrix] or

[strong printmatrix2channel]. The channel argument, [arg chan], has
to be present for the latter and must not be present for the first.

[call [cmd ::csv::split] [arg line] "{[arg sepChar] ,}"]

converts a [arg line] in CSV format into a list of the values
contained in the line. The character used to separate the values from
each other can be defined by the caller, via [arg sepChar], but this
is optional. The default is ",".

[call [cmd ::csv::split2matrix] [arg "m line"] "{[arg sepChar] ,} {[arg expand] none}"]

The same as [cmd ::csv::split], but appends the resulting list as a
new row to the matrix [arg m], using the method [cmd "add row"]. The
expansion mode specified via [arg expand] determines how the command
handles a matrix with less columns than contained in [arg line]. The
allowed modes are:

[list_begin definitions]

[lst_item [strong none]]

This is the default mode. In this mode it is the responsibility of the
caller to ensure that the matrix has enough columns to contain the
full line. If there are not enough columns the list of values is
silently truncated at the end to fit.

[lst_item [strong empty]]

In this mode the command expands an empty matrix to hold all columns
of the specified line, but goes no further. The overall effect is that
the first of a series of lines determines the number of columns in the
matrix and all following lines are truncated to that size, as if mode
[strong none] was set.

[lst_item [strong auto]]

In this mode the command expands the matrix as needed to hold all
columns contained in [arg line]. The overall effect is that after
adding a series of lines the matrix will have enough columns to hold
all columns of the longest line encountered so far.

[list_end]

[call [cmd ::csv::split2queue] [arg "q line"] "{[arg sepChar] ,}"]

The same as [cmd ::csv::split], but appending the resulting list as a
single item to the queue [arg q], using the method [cmd put].

[call [cmd ::csv::writematrix] [arg "m chan"] "{[arg sepChar] ,}"]

A wrapper around [cmd ::csv::join] taking all rows in the matrix
[arg m] and writing them CSV formatted into the channel [arg chan].

[call [cmd ::csv::writequeue] [arg "q chan"] "{[arg sepChar] ,}"]

A wrapper around [cmd ::csv::join] taking all items in the queue
[arg q] (assumes that they are lists) and writing them CSV formatted
into the channel [arg chan].

[list_end]

[section FORMAT]
[para]

Each record of a csv file (comma-separated values, as exported e.g. by
Excel) is a set of ASCII values separated by ",". For other languages
it may be ";" however, although this is not important for this case
(The functions provided here allow any separator character).

[para]

If a value contains itself the separator ",", then it (the value) is
put between "".

[para]

If a value contains ", it is replaced by "".

[section EXAMPLE]

The record

[para]
[example {
123,"123,521.2","Mary says ""Hello, I am Mary"""
}]

[para]
is parsed as follows:

[para]
[example {
a) 123
b) 123,521.2
c) Mary says "Hello, I am Mary"
}]

[see_also matrix queue]
[keywords csv matrix queue package tcllib]
[manpage_end]
