'\"
'\" Copyright (c) 2001 by David N. Welton <davidw@dedasys.com>.
'\" All rights reserved.
'\" 
'\" $Id: irc.n,v 1.4 2002/05/17 11:07:27 davidw Exp $
'\" 
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..

.TH irc n 0.2 IRC "Low Level Tcl IRC Interface"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
::irc \- Create IRC connection and interface.
.SH SYNOPSIS
\fBpackage require Tcl\fR
.sp
\fBpackage require irc ?0.2?\fR
.sp
\fB::irc::connection \fIhostname\fR
.sp
.BE
.SH DESCRIPTION
.PP
This package provides low-level commands to deal with the IRC protocol
(Internet Relay Chat) for immediate and interactive multi-cast
communication.
.PP
The \fB::irc::connection\fR command creates a new object to deal with
an IRC connection.  Creating this IRC object does not automatically
create the network connection.  The \fB::irc::connection\fR command
returns a new irc namespace command which can be used to interact with
the new IRC connection.

.SH Per-connection Commands
.PP
In the following list of available connection methods \fInet\fR
represents a connection command as returned by \fB::irc::connection\fR.
.TP
\fInet \fBregisterevent\fR \fIevent\fR \fIscript\fR 
Registers a callback handler for the specific event.  Events available
are those described in the IRC RFC: 1459.  In addition, there are
several other events defined. \fBdefaultcommand\fR adds a command that
is called if no other callback is present.  \fBEOF\fR is called if the
connection signals an End of File condition.  \fIscript\fR is executed
in the connection namespace, which can take advantage of several
commands (see \fBCallback Commands\fR below) to aid in the parsing of
data.
.TP
\fInet \fBconnect\fR
This causes the socket to be established.  \fB::irc::connection\fR
created the namespace and the commands to be used, but did not
actually open the socket. This is done here.
.TP
\fInet \fBuser\fR \fIusername\fR \fIlocalhostname\fR \fIuserinfo\fR
Sends USER command to server.  \fIusername\fR is the username you want to
appear.  \fIlocalhost name\fR is the name of your server, and \fIuserinfo\fR is a
short description of who you are.
.TP
\fInet \fBnick\fR \fInick\fR
NICK command.  \fInick\fR is the nickname you wish to use for the
particular connection.
.TP
\fInet \fBping\fR
PING the IRC server.
.TP
\fInet \fBjoin\fR \fIchannel\fR
\fIchannel\fR is the IRC channel to join.  IRC channels typically begin
with a #.
.TP
\fInet \fBpart\fR \fIchannel\fR
Makes the client leave \fIchannel\fR.
.TP
\fInet \fBprivmsg\fR \fItarget\fR \fImessage\fR
Sends \fImessage\fR to \fItarget\fR, which can be either a channel, or
another user, in which case their nick is used.
\fInet \fBsend\fR \fItext\fR
Sends \fItext\fR to the IRC server.

.SH Callback Commands
.PP
These commands are used within callbacks
.TP
\fBwho\fR \fI?address?\fR
Returns the nick of the user who performed a command.  The optional
\fIaddress\fR argument causes the command to return the
username@address of the user.
.TP
\fBaction\fR
Returns the action perfomed, such as KICK, PRIVMSG, MODE, etc...
Normally not useful, as callbacks are bound to a particular event.
.TP
\fBtarget\fR \fI?index?\fR
Returns the target of a particular command, such as the channel or
user to whom a PRIVMSG is sent.  In the case of multiple targets, the
optional \fIindex\fR argument may be used to specify which one to
return.  The default is 0.
.TP
\fBmsg\fR
Returns the message portion of the command (the part after the :).
.TP
\fBnetwork\fR
This command permits the use of the per-connection commands from
within callbacks.  For instance, it would be possible from within a
PRIVMSG callback to do the following:
.CS
$cn registerevent PRIVMSG {
    network privmsg [who] "Tcl IRC system at your service"
}
.CE

.SH Global Commands
.PP
.TP
\fB::irc::config\fR \fIkey\fR \fIvalue\fR
Sets configuration \fIkey\fR to \fIvalue\fR.  Currently, the only
config key defined is \fBdebug\fR which, when turned on, makes ::irc
print more information about what is going on.

.SH SEE ALSO
.PP
rfc 1459

.SH KEYWORDS
irc, chat
