/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.IOException;
import java.io.InputStream;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.Util;

class ExecCmd
implements Command {
    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        String string;
        TclObject tclObject;
        int n = tclObjectArray.length;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 1;
        while (n2 < n) {
            tclObject = tclObjectArray[n2];
            if (tclObject.stringRep == null) {
                tclObject.stringRep = tclObject.internalRep.toString();
            }
            if ((string = tclObject.stringRep).length() <= 0 || string.charAt(0) != '-') break;
            if (!string.equals("-keepnewline")) {
                if (string.equals("--")) {
                    ++n2;
                    break;
                }
                throw new TclException(interp, "bad switch \"" + string + "\": must be -keepnewline or --");
            }
            bl2 = true;
            ++n2;
        }
        if (n <= n2) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "?switches? arg ?arg ...?\"");
        }
        tclObject = tclObjectArray[n - 1];
        if (tclObject.stringRep == null) {
            tclObject.stringRep = tclObject.internalRep.toString();
        }
        if ("&".equals(tclObject.stringRep)) {
            tclObjectArray[--n] = null;
            bl = true;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n2;
        while (n3 < n) {
            tclObject = tclObjectArray[n3];
            if (tclObject.stringRep == null) {
                tclObject.stringRep = tclObject.internalRep.toString();
            }
            stringBuffer.append(String.valueOf(tclObject.stringRep) + " ");
            ++n3;
        }
        string = stringBuffer.toString();
        stringBuffer.setLength(0);
        try {
            String string2;
            Process process = !Util.isMac() && (!Util.isWindows() || false) ? this.execUnix(interp, string) : (Util.isWindows() ? Runtime.getRuntime().exec(string) : Runtime.getRuntime().exec(string));
            process.waitFor();
            InputStream inputStream = process.getInputStream();
            boolean bl3 = false;
            while (!bl3) {
                n3 = inputStream.read();
                boolean bl4 = bl3 = n3 == -1;
                if (bl3) continue;
                stringBuffer.append((char)n3);
            }
            this.checkExecError(interp, string, process);
            int n4 = stringBuffer.length();
            if (!bl2 && n4 > 0 && stringBuffer.charAt(n4 - 1) == '\n') {
                stringBuffer.setLength(n4 - 1);
            }
            if ((string2 = stringBuffer.toString()) == null) {
                interp.resetResult();
                return;
            }
            interp.setResult(TclString.newInstance(string2));
            return;
        }
        catch (IOException iOException) {
            throw new TclException(interp, "couldn't execute \"" + string + "\": no such file or directory");
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    private Process execWin(Interp interp, String string) throws IOException, InterruptedException {
        return Runtime.getRuntime().exec(string);
    }

    private Process execUnix(Interp interp, String string) throws IOException, InterruptedException {
        String[] stringArray = new String[]{"sh", "-c", "cd " + interp.getWorkingDir().toString() + "; " + string};
        return Runtime.getRuntime().exec(stringArray);
    }

    private void checkExecError(Interp interp, String string, Process process) throws TclException {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            if (process != null) {
                InputStream inputStream = process.getErrorStream();
                while (!bl) {
                    int n = inputStream.read();
                    boolean bl2 = bl = n == -1;
                    if (bl) continue;
                    stringBuffer.append((char)n);
                }
            }
        }
        catch (IOException iOException) {
            return;
        }
        if (stringBuffer.length() != 0) {
            throw new TclException(interp, "couldn't execute \"" + string + "\": " + stringBuffer);
        }
    }

    ExecCmd() {
    }
}

