/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;

class LrangeCmd
implements Command {
    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length != 4) {
            throw new TclNumArgsException(interp, 1, argv, "list first last");
        }
        int size = TclList.getLength(interp, argv[1]);
        int first = TclInteger.getForIndex((Interp)interp, (TclObject)argv[2], (int)(size - 1));
        int last = TclInteger.getForIndex((Interp)interp, (TclObject)argv[3], (int)(size - 1));
        if (last < 0) {
            interp.resetResult();
            return;
        }
        if (first >= size) {
            interp.resetResult();
            return;
        }
        if (first <= 0 && last >= size) {
            interp.setResult(argv[1]);
            return;
        }
        if (first < 0) {
            first = 0;
        }
        if (first >= size) {
            first = size - 1;
        }
        if (last < 0) {
            last = 0;
        }
        if (last >= size) {
            last = size - 1;
        }
        if (first > last) {
            interp.resetResult();
            return;
        }
        TclObject list = TclList.newInstance();
        list.preserve();
        try {
            int i = first;
            while (i <= last) {
                TclList.append(interp, list, TclList.index(interp, argv[1], i));
                ++i;
            }
            interp.setResult(list);
        }
        finally {
            Object var8_8 = null;
            list.release();
        }
    }

    LrangeCmd() {
    }
}

