/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import tcl.lang.AssocData;
import tcl.lang.Command;
import tcl.lang.Notifier;
import tcl.lang.ReflectObject;
import tcl.lang.TclBoolean;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.Util;
import tcl.lang.VarTrace;

public class Interp {
    long interpPtr;
    Hashtable reflectIDTable;
    Hashtable reflectObjTable;
    long reflectObjCount;
    private Notifier notifier;
    Hashtable assocDataTab;

    private Interp(long l) {
        this.interpPtr = l;
        this.notifier = Notifier.getNotifierForThread((Thread)Thread.currentThread());
        this.notifier.preserve();
        ReflectObject.init(this);
    }

    public Interp() {
        this.interpPtr = this.create();
        this.notifier = Notifier.getNotifierForThread((Thread)Thread.currentThread());
        this.notifier.preserve();
        ReflectObject.init(this);
        if (this.init(this.interpPtr) != 0) {
            String string = this.getResult().toString();
            this.dispose();
            throw new TclRuntimeError(string);
        }
    }

    private final native long create();

    public void dispose() {
        if (this.assocDataTab != null) {
            Enumeration enumeration = this.assocDataTab.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                AssocData assocData = (AssocData)this.assocDataTab.get(k);
                assocData.disposeAssocData(this);
                this.assocDataTab.remove(k);
            }
            this.assocDataTab = null;
        }
        if (this.notifier != null) {
            this.notifier.release();
            this.notifier = null;
        }
        if (this.interpPtr != 0L) {
            Interp.doDispose(this.interpPtr);
            this.interpPtr = 0L;
        }
    }

    protected void finalize() {
        this.dispose();
    }

    File getWorkingDir() {
        return new File(Util.getCwd());
    }

    public final native TclObject setVar(String var1, String var2, TclObject var3, int var4) throws TclException;

    public final TclObject setVar(String string, TclObject tclObject, int n) throws TclException {
        return this.setVar(string, null, tclObject, n | 0x400);
    }

    public final native TclObject getVar(String var1, String var2, int var3) throws TclException;

    public final TclObject getVar(String string, int n) throws TclException {
        return this.getVar(string, null, n | 0x400);
    }

    public final void unsetVar(String string, int n) throws TclException {
        this.unsetVar(string, null, n | 0x400);
    }

    public final native void unsetVar(String var1, String var2, int var3) throws TclException;

    public void traceVar(String string, VarTrace varTrace, int n) throws TclException {
        this.traceVar(string, null, varTrace, n | 0x400);
    }

    public native void traceVar(String var1, String var2, VarTrace var3, int var4) throws TclException;

    public void untraceVar(String string, VarTrace varTrace, int n) throws TclException {
        this.untraceVar(string, null, varTrace, n | 0x400);
    }

    public native void untraceVar(String var1, String var2, VarTrace var3, int var4) throws TclException;

    public native void createCommand(String var1, Command var2);

    public native int deleteCommand(String var1);

    public Command getCommand(String string) {
        throw new TclRuntimeError("Not implemented yet.");
    }

    public static native boolean commandComplete(String var0);

    public final native TclObject getResult();

    public final native void setResult(TclObject var1);

    public final void setResult(String string) {
        this.setResult(TclString.newInstance((String)string));
    }

    public final void setResult(int n) {
        this.setResult(TclInteger.newInstance(n));
    }

    public final void setResult(boolean bl) {
        this.setResult(TclBoolean.newInstance(bl));
    }

    public final void setResult(double d) {
        this.setResult(TclDouble.newInstance(d));
    }

    public final native void resetResult();

    public native void eval(String var1, int var2) throws TclException;

    public void eval(String string) throws TclException {
        this.eval(string, 0);
    }

    public void eval(TclObject tclObject, int n) throws TclException {
        this.eval(tclObject.toString(), n);
    }

    public void evalFile(String string) throws TclException {
        throw new TclRuntimeError("Not implemented yet.");
    }

    void evalResource(String string) throws TclException {
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        if (inputStream == null) {
            throw new TclException(this, "cannot read resource \"" + string + "\"");
        }
        try {
            try {
                byte[] byArray = new byte[inputStream.available()];
                inputStream.read(byArray);
                this.eval(new String(byArray), 0);
            }
            catch (IOException iOException) {
                Object var4_4 = null;
                this.closeInputStream(inputStream);
                return;
            }
            Object var4_5 = null;
            this.closeInputStream(inputStream);
            return;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.closeInputStream(inputStream);
            throw throwable;
        }
    }

    private void closeInputStream(InputStream inputStream) {
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    private int callCommand(Command command, TclObject[] tclObjectArray) {
        try {
            command.cmdProc(this, tclObjectArray);
            return 0;
        }
        catch (TclException tclException) {
            return tclException.getCompletionCode();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new TclRuntimeError("Error in command implementation");
        }
    }

    public native void setErrorCode(TclObject var1);

    public native void addErrorInfo(String var1);

    public native void backgroundError();

    public Notifier getNotifier() {
        return this.notifier;
    }

    public void setAssocData(String string, AssocData assocData) {
        if (this.assocDataTab == null) {
            this.assocDataTab = new Hashtable();
        }
        this.assocDataTab.put(string, assocData);
    }

    public void deleteAssocData(String string) {
        if (this.assocDataTab == null) {
            return;
        }
        this.assocDataTab.remove(string);
    }

    public AssocData getAssocData(String string) {
        if (this.assocDataTab == null) {
            return null;
        }
        return (AssocData)this.assocDataTab.get(string);
    }

    private final native int init(long var1);

    private static final native void doDispose(long var0);

    public final native void pkgProvide(String var1, String var2);

    public final native String pkgRequire(String var1, String var2, boolean var3);

    static {
        System.loadLibrary("tclblend");
    }
}

