proc prog_help.html {} { return {
<Title> Menu Editor Programmer's Help </title>
<h1> The Menu Editor : Programmer's Help </h1>

<i>This document currenly assumes some familiarilty with Tk programming.</i>

<h2><b>Instantiating a menu inside your Tcl program</b></h2>
<p>

When you have finished building your menu, choose <i>Build + Run</i>
from the <i>File</i> menu.  This saves your menu in a
file called (for example) <i>mymenu</i>.menu.  The Menu Editor also saves a file
called <i>mymenu</i>.menu.tcl, which contains Tcl code to create
your menu. <p>

The <i>mymenu</i>.menu.tcl contains a Tcl procedures called
<i>mymenu</i>_menu.  Call this procedure and pass it the name of a
frame widget (to act as a menubar) in your application.  The procedure
creates your entire menu as a child of the frame widget.  Here is a
sample Tcl program: <p>

<b>
<dl COMPACT>
	frame .f<br>
	pack .f<br>
	source mymenu.menu.tcl<br>
	mymenu_menu .f
</dl>
</b>
<p> Type this program into your favorite text editor and save it as
mymenu.tcl. 
<p>

<h2><b>Adding programmed behavior to menu items </b></h2>
<p>
The menu editor provides several properties which act as hooks into
Tcl procedures in your program.  Most menu items have a <i>command</i>
property.  This property specifies a Tcl script (which usually
consists of just a single procedure call) to execute when the user
selects the item from the menu.  
<p>
For example, add the following procedure to the short Tcl program
above, and save the file, again as mymenu.tcl.<p>

<b>
<dl COMPACT>
	proc testCmd {} {
	<dl COMPACT>
		puts "Test Successful!"
	</dl>
	}
</dl>
</b>
<p>

Now, type a simple menu into the menu editor.  Set the command
property of one of your menu items to be "testCmd".  Choose <i>Save As</i>
from the <i>File</i> menu, and call the file mymenu.  Now choose <i>Build + Run</i>
from the <i>File</i> menu.  Your menu will appear in a new window on
the screen, and when you click on the menu item for which you set the
command property, "Test Successful!" will be printed out.

<p>
Note that for menubuttons, there is only a "postcommand" property.
The postcommand is a Tcl script which is executed before the menu
attached to the menubutton is posted.  You can use the postcommand to
(for example) update the labels appearing in the menu before the menu
pops up.
<p>


<h2><b>Configuring individual menu items </b></h2>
<p>
The menu editor only exposes a small fraction of the properties which
Tk defines for menubuttons, menus, and items in those menus.  In some
cases you might want to access these other properties, so the Menu
Editor defines a second Tcl procedure called <i>mymenu_getmenuname</i>
in the <i>mymenu</i>.menu.tcl file to help you with this task.
<p> 

This procedure allows you to determine the name of the Tk widget which
is managing a given menu item (or menu button).  The procedure takes
the name of the menubar (a frame widget) and the text for the menu
item which appears in the Menu Editor.  <p>

This example retrieves the Tk widget name of a "Print file" menu item
from a menubar named .f, and configures it to have a red background
color. <p>

<b>
<dl COMPACT>
	set tk_name [mymenu_getmenuname .f "Print file"]<br>
	$tk_name entryconfigure "Print file" -background red
</dl>
</b>
<p>

For menubuttons, the second line above would read:<p>
<b>
<dl COMPACT>
	$tk_name configure -background red
</dl>
</b>
<p>


<br>
<p>
<i>Last updated 8-31-95</i>
}}
