#include <stdio.h>
#include "./evap.h"
#include "../pdt/sample_pdt_out"

int main(int argc,
	 char *argv[]);

/* evap 2 - pointer version, unconverted values, types, lists */

int main(int argc, char *argv[])
{

  evap_List_Value *lve;		/* list value entry */
  evap_Parameter_Value *pvte;	/* parameter value table entry */

  evap (&argc, &argv, pdt, NULL, pvt); /* evaluate parameters */
  printf("\nProgram name:\n  %s\n", pvt[P_HELP].unconverted_value);

  if (P_NUMBER_OF_PARAMETERS > 1) {

    printf("\nCommand parameters and values:\n");
    pvte = &pvt[1];		/* ignore -help parameter */

    while (pvte->parameter != NULL) {

      lve = pvte->list;		/* get 'list of' indicator */
      printf( "\n   \"%s%s\" parameter \"%s\" ...\n",
	     (lve != NULL) ? "list of " : "", evap_Type_Strings[pvte->type],
	     pvte->parameter );

      if ( lve == NULL ) {	/* not 'list of' parameter */
	printf( "           value = \"%s\"\n", pvte->unconverted_value );
      } else {
	printf( "          values = (" ); 

	while (lve->unconverted_value != NULL ) {

	  printf(" \"%s\"", lve->unconverted_value);
	  lve++;		/* next list value entry */
	  printf( "%s", lve->unconverted_value !=NULL ? ", " : "" );

	} /* whilend */

	printf( " )\n" );
      } /* ifend */

      pvte++;			/* next parameter value table entry */

    } /* whilend */

  } /* ifend command line parameters */

  if (argc > 1) {		/* if trailing file names */

    printf("\nFile names:\n  ");
    while (*++argv != NULL)
      printf("%s%s",*argv, (*argv != NULL) ? " " : "");
    printf("\n");

  } /* ifend */

  exit( 0 );

} /* end main */
