# ftocFind.tcl
#
# Searching on the folder table of contents
#
# Copyright (c) 1993 Xerox Corporation.
# Use and copying of this software and preparation of derivative works based
# upon this software are permitted. Any distribution of this software or
# derivative works must comply with all applicable United States export
# control laws. This software is made available AS IS, and Xerox Corporation
# makes no warranty about the software, its performance or its conformity to
# any specification.

proc Ftoc_Find { string {dir forw} } {
    global exwin ffind ftoc
    if ![info exists ffind(line)] {
	set ffind(line) $ftoc(curLine)
    }
    if {$ffind(line) == {}} {
	set ffind(line) 1
    }
    if {$string == {}} {
	Exmh_Status "No search string" red
	return
    }
    set L $ffind(line)
    if {$dir == "forw"} {
	for {incr L} {$L <= $ftoc(numMsgs)} {incr L} {
	    if [FtocFindMatch $L $string] return
	}
	for {set L 0} {$L < $ffind(line)} {incr L} {
	    if [FtocFindMatch $L $string] return
	}
    } else {
	for {incr L -1} {$L >= 1} {incr L -1} {
	    if [FtocFindMatch $L $string] return
	}
	for {set L $ftoc(numMsgs)} {$L > $ffind(line)} {incr L -1} {
	    if [FtocFindMatch $L $string] return
	}
    }
    Exmh_Status "No messages found" red
}
proc Ftoc_FindNext {} {
    if [catch {.find.entry get} string] {
	Ftoc_Find
	return
    }
    Ftoc_Find $string forw
}
proc Ftoc_FindPrev {} {
    if [catch {.find.entry get} string] {
	Ftoc_Find
	return
    }
    Ftoc_Find $string back
}
proc FtocFindMatch {L string} {
    global exwin
    if [catch {$exwin(ftext) get $L.0 $L.end} text] {
	return 0
    }
    if [regexp $string $text] {
	global ffind
	set ffind(line) $L
	focus $exwin(ftext)
	Msg_Pick $L show
	Exmh_Status "Find hit: <Control-s> next, <Control-r> prev" blue
	return 1
    }
    return 0
}


