/* Copyright (c) 1993 by Sanjay Ghemawat */
/*
 * Miscellaneous Tk commands.
 */

#include <stdio.h>
#include <string.h>
extern "C" {
#include <tcl.h>
#include <tk.h>
}

#include "commands.h"
#include "misc_tcl.h"

/*
 * Raise Tk Window.
 *
 *	wraise <windowname>
 */
int Cmd_WindowRaise(ClientData c, Tcl_Interp* tcl,int argc,char* argv[]){
    Tk_Window tkwin = (Tk_Window) c;

    if (argc != 2) {
	TCL_Error(tcl, "illegal number of arguments to wraise");
    }

    Tk_Window w = Tk_NameToWindow(tcl, argv[1], tkwin);
    if (w == NULL) {
	TCL_Error(tcl, "not a window");
    }

    XRaiseWindow(Tk_Display(w), Tk_WindowId(w));
    TCL_Return(tcl, "");
}

/*
 * Beep.
 *
 *	wbeep [-100..100]
 */
int Cmd_Beep(ClientData c, Tcl_Interp* tcl,int argc,char* argv[]){
    Tk_Window tkwin = (Tk_Window) c;

    if (argc != 2) {
	TCL_Error(tcl, "illegal number of arguments to wraise");
    }

    int i;
    if (Tcl_GetInt(tcl, argv[1], &i) != TCL_OK) {
	return TCL_ERROR;
    }

    if ((i < -100) || (i > 100)) {
	TCL_Error(tcl, "invalid volume");
    }

    XBell(Tk_Display(tkwin), i);
    TCL_Return(tcl, "");
}
