# Copyright (c) 1993 by Sanjay Ghemawat
#############################################################################
# Dialog for getting range of time from a day.
#
# Commands
#
#	get_time_range <leader> <msg> <varstart> <varfinish>
#
#	Allow user to edit time range.  The initially displayed range
#	is taken from the value of the variables named by <varstart>
#	and <varfinish>.  If user confirms the dialog, set <varstart>
#	and <varfinish> to the new values and return 1.  Else
#	return 0.
#
#	<varstart> and <varfinish> take integral values in the range 0..24
#	to represent hours.

class TimeRange {w gvar} {
    set slot(window) $w
    set slot(gvar) $gvar

    toplevel $w -class Dialog -geometry ""
    wm title $w "Set Time Range"
    wm protocol $w WM_DELETE_WINDOW [list set $gvar 0]
    
    frame $w.mid -relief raised -bd 1
    frame $w.bot -relief raised -bd 1
    frame $w.bot.default -relief sunken -bd 1

    frame $w.mid.top -relief flat -bd 0
    frame $w.mid.bot -relief flat -bd 0
    label $w.mid.mid -relief flat -bd 0 -text to

    scale $w.start -from 0 -to 24 -tickinterval 0\
	-orient horizontal -length 3i\
	-showvalue 0 -command [list $self start]

    label $w.slabel -text "" -width 8

    scale $w.finish -from 0 -to 24 -tickinterval 0\
	-orient horizontal -length 3i\
	-showvalue 0 -command [list $self finish]

    label $w.flabel -text "" -width 8

    message $w.msg -aspect 400 -text {Edit time range} -relief raised -bd 1

    button $w.bot.default.yes -text Okay -command [list set $gvar 1]
    button $w.bot.no -text Cancel -command [list set $gvar 0]

    pack $w.slabel -in $w.mid.top -side left
    pack $w.start -in $w.mid.top -side right -fill x

    pack $w.flabel -in $w.mid.bot -side left
    pack $w.finish -in $w.mid.bot -side right -fill x

    pack $w.mid.top -side top -fill x -padx 3m
    pack $w.mid.mid -side top -fill x
    pack $w.mid.bot -side top -fill x -padx 3m

    pack $w.bot.default.yes -side left -padx 2m -pady 2m
    pack $w.bot.no -side left -expand 1 -padx 4m -pady 4m
    pack $w.bot.default -side left -expand 1

    pack $w.msg -side top -fill x
    pack $w.mid -side top -fill x
    pack $w.bot -side top -fill x

    bind $w <Control-c> {set tr_done 0}
    bind $w <Return>    {set tr_done 1}

    $self edit 0 24

    wm withdraw $w
    update
}

method TimeRange start {value} {
    if {$value >= [$slot(window).finish get]} {
	set value [expr [$slot(window).finish get] - 1]
	$slot(window).start set $value
    }
    
    $slot(window).slabel config -text [time2text [expr $value*60]]
}
    
method TimeRange finish {value} {
    if {$value <= [$slot(window).start get]} {
	set value [expr [$slot(window).start get] + 1]
	$slot(window).finish set $value
    }
    
    $slot(window).flabel config -text [time2text [expr $value*60]]
}

method TimeRange edit {start finish } {
    $slot(window).start set $start
    $slot(window).finish set $finish
    $self start $start
    $self finish $finish
}

set tr_done -1

# Create dialog when this file is auto-loaded.
TimeRange-with-name time_range_dialog .tr tr_done

proc get_time_range {leader msg varstart varfinish} {
    global tr_done
    upvar $varstart start
    upvar $varfinish finish

    set tr_done -1
    time_range_dialog edit $start $finish
    .tr.msg configure -text $msg
    dialog_run $leader .tr .tr tr_done
    if $tr_done {
	set start [.tr.start get]
	set finish [.tr.finish get]
    }
    return $tr_done
}
