/* Copyright (c) 1993 by Sanjay Ghemawat */
#include "commands.h"
#include "misc_tcl.h"
#include "cal_tcl.h"
#include "item_tcl.h"

/*
 * Notice Creator
 *
 *	notice <name>
 */

int Cmd_CreateNotice(ClientData, Tcl_Interp* tcl, int argc, char* argv[]) {
    if (argc != 1) {
	TCL_Error(tcl, "invalid arguments to notice");
    }

    Item_Tcl* item = new Item_Tcl(tcl, new Notice(0));
    TCL_Return(tcl, (char*) item->handle());
}

/*
 * Appointment Creator
 *
 *	appointment <name>	-- Returns <name>
 */

int Cmd_CreateAppt(ClientData, Tcl_Interp* tcl, int argc, char* argv[]) {
    if (argc != 1) {
	TCL_Error(tcl, "invalid arguments to appointment");
    }

    Item_Tcl* item = new Item_Tcl(tcl, new Appointment(0));
    TCL_Return(tcl, (char*) item->handle());
}

/*
 * Calendar Creator
 *
 *	calendar <name> <filename>	-- Returns <name>
 */

int Cmd_CreateCalendar(ClientData, Tcl_Interp* tcl, int argc, char* argv[]) {
    if (argc != 3) {
	TCL_Error(tcl, "invalid arguments to calendar");
    }

    new Calendar_Tcl(tcl, argv[1], argv[2]);
    TCL_Return(tcl, "");
}
