# ~/.tk/jeditrc.tcl - user customisation file for edit.tk
# this adds a `colours' menu for highlighting
######################################################################

######################################################################
# new procedures:

proc jedit:colours:clear_background {} {
  set t .main.t
  foreach tag [.main.t tag names] {
    if {[string match "background:*" $tag]} {
      catch {
        .main.t tag remove $tag sel.first sel.last
      }
    }
  }
}

proc jedit:colours:clear_foreground {} {
  set t .main.t
  foreach tag [.main.t tag names] {
    if {[string match "foreground:*" $tag]} {
      catch {
        .main.t tag remove $tag sel.first sel.last
      }
    }
  }
}

######################################################################
# additions to GUI:

proc jedit:userhook {} {
  menubutton .menu.colours -text {Colours} -menu .menu.colours.m
  tk_menuBar .menu \
    .menu.editor .menu.file .menu.edit .menu.abbrev .menu.pipe .menu.colours
  pack .menu.colours -in .menu -side left
  
  menu .menu.colours.m

  # make selection underlined, so it's visible even with background tags
  
  .main.t tag configure sel -underline yes
  
  foreach background {
    Pink
    Green
    SkyBlue
    Yellow
    Cyan
    Violet
  } {
    .main.t tag configure background:$background -background $background
    .menu.colours.m add command \
      -label "Background: $background" -command [format {
      jedit:colours:clear_background
      catch {
        .main.t tag add background:%s sel.first sel.last
      }
    } $background]
  }
  .menu.colours.m add command -label "Background: Plain" -command {
    jedit:colours:clear_background
  }
  .menu.colours.m add separator
  foreach foreground {
    Red
    DarkGreen
    Blue
    Orange
    CadetBlue
    Magenta
  } {
    .main.t tag configure foreground:$foreground -foreground $foreground
    .menu.colours.m add command \
      -label "Foreground: $foreground" -command [format {
      jedit:colours:clear_foreground
      catch {
        .main.t tag add foreground:%s sel.first sel.last
      }
    } $foreground]
  }
  .menu.colours.m add command -label "Foreground: Plain" -command {
    jedit:colours:clear_foreground
  }
  .menu.colours.m add separator
  .menu.colours.m add command -label "Clear Colours" -command {
    jedit:colours:clear_foreground
    jedit:colours:clear_background
  }
}
