proc moogDoMarks {file} {

  global mark env
  global bookType bookName bookPath bookHost bookPort

  wm maxsize . 500 800
  wm geometry . 500x300
  wm title . {Moog 0.2 Bookmarks}

  label .messageLabel \
    -text "Moog Bookmarks"

  frame .bookMarks \
    -borderwidth {3}\
    -relief {sunken}

  scrollbar .bookMarks.scroller \
    -command ".bookMarks.listing yview"\
    -relief {sunken}

  listbox .bookMarks.listing \
    -geometry {10x2}\
    -yscroll ".bookMarks.scroller set"\
    -relief {raised}

  pack append .bookMarks \
    .bookMarks.listing {left frame center expand fill} \
    .bookMarks.scroller {left frame center fill} 

  frame .controlFrame \
    -borderwidth {3}

  button .controlFrame.fetchButton \
    -text {Fetch}\
    -command {foreach y [.bookMarks.listing curselection] {\
         moogBookFetch $y}}

  button .controlFrame.infoButton \
    -text {Info} \
    -command "moogInfoCB book x"

  button .controlFrame.deleteButton \
    -text {Delete}\
    -command {foreach y [.bookMarks.listing curselection] {\
         moogBookDelete $y}}

  button .controlFrame.deleteAllButton \
    -text {Delete All}\
    -command {moogBookDeleteAll}

  button .controlFrame.reloadAllButton \
    -text {Reload}\
    -command "if {[file exists $file]} {\
      moogBookReloadAll $file }"

  button .controlFrame.saveAllButton \
    -text {Save}\
    -command "moogBookSaveAll $file"

  button .controlFrame.exitButton \
    -text {Exit}\
    -command "moogExitCB $file"

  pack append .controlFrame \
    .controlFrame.fetchButton {left frame center expand fillx} \
    .controlFrame.infoButton {left frame center expand fillx} \
    .controlFrame.deleteButton {left frame center expand fillx} \
    .controlFrame.deleteAllButton {left frame center expand fillx} \
    .controlFrame.reloadAllButton {left frame center expand fillx} \
    .controlFrame.saveAllButton {left frame center expand fillx} \
    .controlFrame.exitButton {left frame center expand fillx} 

  pack append . \
    .messageLabel {top frame center fillx} \
    .bookMarks {top frame center expand fill} \
    .controlFrame {top frame center fillx} 

  bind .bookMarks.listing <Double-Button-1> { \
    foreach y [.bookMarks.listing curselection] { \
         moogBookFetch $y }}

  if {[file exists $file]} {
    moogBookReloadAll $file
  }
}

