
#ifndef _TM_H
#define _TM_H

#include <stdio.h>
#include <stdlib.h>
#include <tcl/tcl.h>
#include <tcl/regexp.h>
#include <Xm/Xm.h>
#include <tcl/tclHash.h>

#define TM_MAXARGS 100

/* global vbl names for stuf used in Text verify callbacks */
#define TM_TEXT_DOIT "_Tm_Text_Doit"
#define TM_TEXT_STARTPOS "_Tm_Text_StartPos"
#define TM_TEXT_ENDPOS "_Tm_Text_EndPos"
#define TM_TEXT_PTR "_Tm_Text_Ptr"
#define TM_TEXT_LENGTH "_Tm_Text_Length"

typedef struct Tm_Widget {
    Widget	widget;
    char	*pathName;
    Widget 	toplevel;
    Tcl_Interp  *interp;
    char 	*parent;
}   Tm_Widget;

typedef struct Tm_ClientData {
    char	*callback_func;
    Tm_Widget   *widget_info;
}   Tm_ClientData;

extern Tcl_HashTable WidgetTable;

typedef struct {
    char *fileName;
}   Tm_ResourceType, *Tm_ResourceTypePtr;

typedef int (*Tm_WidgetCmdProc)_ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp,
            int argc, char **argv));

#endif /* _TM_H */
