%{

/*
 *  Copyright (C) 1993 Michael Tiller
 *
 *  Permission is hereby granted by the author to use, copy, modify,
 *  and distribute this code for any purpose provided this copyright
 *  notice is included in all copies.  This code is provided "as is"
 *  without any expressed or implied warranty.
 *
 */

#undef	YY_DECL
#define	YY_DECL int deriv_lex YY_PROTO((void))
#undef	YY_INPUT
#define	YY_INPUT(buf,result,max_size)	deriv_input(buf,&result,max_size)

#include	<string.h>
#include	"expr.h"
#define YYSTYPE	ExprPtr
#include	"deriv.h"

double	atof();
void	deriv_input();

extern	YYSTYPE	deriv_lval;

#define	FLEX_DEBUG
%}

I	[0-9]+
DREAL	([0-9]*"."[0-9]+)
EREAL	([0-9]*"."[0-9]+[eE][+-]?[0-9]+)
REAL	{DREAL}|{EREAL}|{I}

%%
{REAL}	{
	deriv_lval = MakeConst(atof(yytext));

	return NUM;
}

[$@a-zA-Z]*[a-zA-Z0-9_]+	{
	deriv_lval = MakeId(strdup(yytext));

	return ID;
}

"+"	return ADD;
"-"	return SUB;
"*"	return MULT;
"/"	return DIV;
"^"	return EXP;
"("	return LP;
")"	return RP;

[ \t\n]* ;

.	{
	fprintf(stderr, "Error, character %c ignored\n", yytext[0]);
}


%%

static	char	*deriv_pos;

void
deriv_setpos(char *str)
{
	deriv_pos = str;
}

int
deriv_getchar()
{
	int	ret = *deriv_pos;
	if (*deriv_pos != '\0')
	{
		deriv_pos++;
		return ret;
	}
	else
		return EOF;
}

void
deriv_ungetc(char c, FILE *file)
{
	deriv_pos--;
}

int
deriv_error()
{
	return 0;
}
void
deriv_input(buf,result,max_size)
char *buf;
int	*result;
int max_size;
{
	char	*ptr = buf;
	int	done;

	*result = 0;
	for(*result=0;
		(*ptr=deriv_getchar())!=EOF && *result<max_size;
		(*result)++,ptr++);
}

void
deriv_reset()
{
	/* This is a hack.  Doing this may hammer flex pretty hard, I
	   didn't really look into it. */

	yy_init = 1;
}
