# use_buttons.tcl
# 
# Copyright (c) 1994 R"udiger Franke
# All Rights Reserved.
# 
# Redistribution and use in any form, with or without modification, 
# is permitted, provided that the following conditions are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in other form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. All advertising materials mentioning features or use of this software
#    must display the following acknowledgement:
#       This product includes software developed by R"udiger Franke.
# 4. The name of the author may not be used to endorse or promote products
#    derived from this software without specific prior written permission.
# 
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
# IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
# NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
# THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#
# constructor for "use_buttons"
#
proc use_buttons {w widget buttons default args} {
  upvar #0 $w this

  # data initializations

  set this(use_buttons) $w
  
  # widget creations

  frame $this(use_buttons) -class Use_buttons
  
  useCreateComponent use_buttons $w $args

  # user additions

  # build a row of buttons
  
  set this(def,button) {}
  set i 0
  foreach button $buttons {
    set bname button$i
    if {$button == $default} {
      frame $w.default -bd 1 -relief sunken
      set this(def,button) $w.$bname
      button $w.$bname  -text $button  -command "$widget [string tolower $button]"
      pack $w.$bname -in $w.default -expand true -padx 1m -pady 1m
      pack $w.default -side left -expand true
    } else {
      button $w.$bname  -text $button  -command "$widget [string tolower $button]"
      pack $w.$bname -side left -expand true
    }
    incr i
  }

  return $w
}

#
# method "defaultaction"
#
proc use_buttons::defaultaction {w } {
  upvar #0 $w this

  if {$this(def,button) != {}} {
    $this(def,button) flash
    $this(def,button) invoke
  }
}

