# use_cmdline.tcl
# 
# Copyright (c) 1994 R"udiger Franke
# All Rights Reserved.
# 
# Redistribution and use in any form, with or without modification, 
# is permitted, provided that the following conditions are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in other form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. All advertising materials mentioning features or use of this software
#    must display the following acknowledgement:
#       This product includes software developed by R"udiger Franke.
# 4. The name of the author may not be used to endorse or promote products
#    derived from this software without specific prior written permission.
# 
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
# IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
# NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
# THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#
# constructor for "use_cmdline"
#
proc use_cmdline {w  args} {
  upvar #0 $w this

  # user initializations

  global use
  
  if {![info exists use(target)]} {
    set use(target) {}
  }
  
  # data initializations

  set this(use_cmdline) $w
  set this(yscroll) $w.yscroll
  set this(tclsh) $w.tclsh
  
  # widget creations

  frame $this(use_cmdline) -class Use_cmdline
  scrollbar $this(yscroll)  \
    -command "$this(tclsh) yview" \
    -relief "sunken"
  use_tclsh $this(tclsh) $use(target) \
    -borderwidth "2" \
    -relief "sunken" \
    -yscrollcommand "$this(yscroll) set"
  
  # widget layouting

  pack $this(yscroll) -side right -fill y
  pack $this(tclsh) -side left -fill both -expand true
  
  useCreateComponent use_cmdline $w $args

  # user additions

  trace variable use(target) w "$w newTarget"

  return $w
}

#
# method "_destroyed"
#
proc use_cmdline::_destroyed {w } {
  upvar #0 $w this

  global use
  trace vdelete use(target) w "$w newTarget"
}

#
# method "newTarget"
#
proc use_cmdline::newTarget {w {name1 use} {name2 target} {op w}} {
  upvar #0 $w this

  global use
  $this(tclsh) interp $use(target)
}

