# use_layout.tcl
# 
# Copyright (c) 1994 R"udiger Franke
# All Rights Reserved.
# 
# Redistribution and use in any form, with or without modification, 
# is permitted, provided that the following conditions are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in other form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. All advertising materials mentioning features or use of this software
#    must display the following acknowledgement:
#       This product includes software developed by R"udiger Franke.
# 4. The name of the author may not be used to endorse or promote products
#    derived from this software without specific prior written permission.
# 
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
# IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
# NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
# THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#
# constructor for "use_layout"
#
proc use_layout {w  args} {
  upvar #0 $w this

  # data initializations

  set this(use_layout) $w
  set this(title) $w.title
  set this(label0) $w.title.label0
  set this(entry0) $w.title.entry0
  set this(label1) $w.title.label1
  set this(entry1) $w.title.entry1
  set this(label2) $w.title.label2
  set this(label3) $w.title.label3
  set this(frame0) $w.frame0
  set this(text) $w.frame0.text
  set this(buttons) $w.buttons
  set this(read) $w.buttons.read
  set this(apply) $w.buttons.apply
  
  # widget creations

  frame $this(use_layout) -class Use_layout
  frame $this(title) 
  label $this(label0)  \
    -text "Component: " \
    -anchor w
  entry $this(entry0)  \
    -relief sunken \
    -textvar $w\(cur,compname)
  label $this(label1)  \
    -text "Master Widget: " \
    -anchor w
  entry $this(entry1)  \
    -relief sunken \
    -textvar $w\(cur,wname)
  label $this(label2)  \
    -text "Geometry Tool: " \
    -anchor w
  label $this(label3)  \
    -textvar "$w\(cur,geomcmd)" \
    -anchor w
  frame $this(frame0)  \
    -borderwidth 2 \
    -relief sunken
  text $this(text) 
  frame $this(buttons) 
  button $this(read)  \
    -text Read \
    -command "$w read"
  button $this(apply)  \
    -text Apply \
    -command "$w apply"
  
  # widget layouting

  blt_table $this(title) \
    $this(label0) 0,0 -anchor w \
    $this(entry0) 0,1 -fill x \
    $this(label1) 1,0 -anchor w \
    $this(entry1) 1,1 -fill x \
    $this(label2) 2,0 -anchor w \
    $this(label3) 2,1 -fill x
  blt_table column $this(title) configure 0 -resize none
  pack $this(text) -fill both -expand true
  pack $this(read) $this(apply) \
    -side left -expand true
  pack $this(title) \
    -side top \
    -padx 2m -pady 2m \
    -fill both
  pack $this(buttons) \
    -side bottom \
    -anchor center \
    -fill both \
    -pady 2m
  pack $this(frame0) \
    -side top \
    -padx 2m -pady 2m \
    -fill both \
    -expand true
  
  useCreateComponent use_layout $w $args

  # user additions

  blt_drag&drop target $w handler use_widget "
    $w compname \[lindex \$DragDrop(use_widget) 0\]
    $w wname \[lindex \$DragDrop(use_widget) 1\]
    $w read
  "
  blt_drag&drop target $w handler use_component "
    $w compname \$DragDrop(use_component)
  "
  foreach widget "$w $this(entry0) $this(entry1)" {
     bind $widget <Return> "$this(apply) flash; $this(apply) invoke"
  }
  
  set this(cur,compname) {}
  set this(cur,wname) {}
  set this(cur,geomcmd) {}
  

  return $w
}

#
# method "apply"
#
proc use_layout::apply {w } {
  upvar #0 $w this

  global use
  
  if { $this(cur,compname) == {}
      || $this(cur,wname) == {}} return
  
  set tree $use(tree,$this(cur,compname))
  set managers $use(geomcmds)
  set geom [$this(text) get 0.0 end]
  
  
  # find out current geometry manager from edited code
  
  set geomcmd {}
  foreach cmd $managers {
    set index [string first $cmd $geom]
    if {$index > -1} {
      set geomcmd $cmd
      break
    }
  }
  set this(cur,geomcmd) $geomcmd
  
  # let new geometry be applied
  # (delete layout for when the text field is empty)
  
  if {$geomcmd != {}} {
    $tree nodelayout $this(cur,wname) $geomcmd $geom
  } else {
    if {[string trim $geom] == {}} {
      $tree nodelayout $this(cur,wname) {}
    } else {
      dialog $w._d_ USE \
        "Found no tool.\n(searched for: [join $managers {, }])" \
        error 0 OK
    }
  }
  
}

#
# method "compname"
#
proc use_layout::compname {w args} {
  upvar #0 $w this

  if {[llength $args] == 0} {
    return $this(cur,compname)
  } else {
    set this(cur,compname) [lindex $args 0]
  }
}

#
# method "read"
#
proc use_layout::read {w } {
  upvar #0 $w this

  global use
  
  if { $this(cur,compname) == {}
      || $this(cur,wname) == {}} return
  
  set tree $use(tree,$this(cur,compname))
  set geom [$tree nodelayout $this(cur,wname)]
  set this(cur,geomcmd) [lindex $geom 0]
    
  $this(text) delete 0.0 end
  $this(text) insert 0.0 [lindex $geom 1]
  
}

#
# method "wname"
#
proc use_layout::wname {w args} {
  upvar #0 $w this

  if {[llength $args] == 0} {
    return $this(cur,wname)
  } else {
    set this(cur,wname) [lindex $args 0]
  }
}

