#-----------------------------------------------------------------------------
#  Emacs-like bindings for Tk text widgets
#
#	Andrew C. Payne
#	payne@crl.dec.com
#
#-----------------------------------------------------------------------------

set tk_priv(cutbuffer) ""

#-----------------------------------------------------------------------------
# Keyboard bindings, model after emacs
#-----------------------------------------------------------------------------

proc emacs-text-move {w where} {
	global tk_priv

	$w mark set insert $where
	$w yview -pickplace insert
	if {$tk_priv(selectMode) == "select"} {
		$w tag remove sel 0.0 end
		$w tag add sel anchor insert
	}
}

proc emacs-twiddle {w} {
	set c [$w get insert-1c]
	$w delete insert-1c
	$w insert insert-1c $c
}

proc emacs-move-page {w dir} {
	global tk_priv

        set height [lindex [$w configure -height] 4]
        $w mark set insert "insert $dir $height lines"
        $w yview -pickplace insert
	if {$tk_priv(selectMode) == "select"} {
		$w tag remove sel 0.0 end
		$w tag add sel anchor insert
	}
}

#
#  If there is a current selection, delete it.  Else, backspace one character
#
proc emacs-backspace {w} {
	if {[catch {$w delete sel.first sel.last}]} {
		tk_textBackspace $w
	}
	$w yview -pickplace insert	
}

bind Text <Up> 		{emacs-text-move %W insert-1l}
bind Text <Down> 	{emacs-text-move %W insert+1l}
bind Text <Left> 	{emacs-text-move %W insert-1c}
bind Text <Right> 	{emacs-text-move %W insert+1c}

bind Text <Control-a>	{emacs-text-move %W {insert linestart}}
bind Text <Control-b> 	{emacs-text-move %W insert-1c}
bind Text <Control-d>	{%W delete insert insert+1c}
bind Text <Control-e>	{emacs-text-move %W {insert lineend}}
bind Text <Control-f> 	{emacs-text-move %W insert+1c}
bind Text <Control-h>	{emacs-backspace %W}
bind Text <Control-k>	{%W delete insert {insert lineend}}
bind Text <Control-n> 	{emacs-text-move %W insert+1l}
bind Text <Control-o>	{%W insert insert "\n"; emacs-text-move %W insert-1c}
bind Text <Control-p> 	{emacs-text-move %W insert-1l}
bind Text <Control-t>	{emacs-twiddle %W}
bind Text <Control-v>	{emacs-move-page %W +}

bind Text <Prior> 	{emacs-move-page %W -}
bind Text <Next>	{emacs-move-page %W +}
bind Text <Delete>	{emacs-backspace %W}

bind Text <Insert> {
        %W insert insert $tk_priv(cutbuffer)
        %W yview -pickplace insert
}

bind Text <Select> {
	%W tag remove sel 0.0 end
	if {$tk_priv(selectMode) == "select"} {
		set tk_priv(selectMode) {}
	} {
		%W mark set anchor insert
		set tk_priv(selectMode) select
	}
}

bind Text <Any-KeyPress> {
	if {%k == 140} {
		set tk_priv(selectMode) {}
		catch {set tk_priv(cutbuffer) [%W get sel.first sel.last]}
		catch {%W delete sel.first sel.last}
	}
	if {"%A" != ""} {
		%W insert insert %A
	}
	%W yview -pickplace insert
}

#-----------------------------------------------------------------------------
#  Mouse bindings
#-----------------------------------------------------------------------------

bind Text <1> {
	set tk_priv(selectMode) char
	%W mark set insert @%x,%y
	%W mark set anchor insert
	if {[lindex [%W config -state] 4] == "normal"} {focus %W}
	%W tag remove sel 0.0 end
}

#
#  Button 2 is used to paste the current X selection, just like many X
#  applications.  This is the default Motif binding.
#
bind Text <2> {
	catch {	
		%W insert insert [selection get]
		%W yview -pickplace insert
	}
}

bind Text <B2-Motion> {}

#
#  Use button 3 as a drag for window text (just like the old Tk button 2
#  binding.
#
bind Text <3>		{%W scan mark %y}
bind Text <B3-Motion>	{%W scan dragto %y}
