.TH EXPECTERM 1 "18 June 1992"
.SH NAME
.B expecTerm -- expect with terminal emulation
.SH SYNOPSIS
.B expecTerm 
[
.I expect_options
]
.SH INTRODUCTION
.B expecTerm 
adds terminal emulation to Don Libes' 
.B expect 
program.
The standard 
.B expect 
commands are all supported, making 
.B expecTerm
compatible with existing expect scripts.  

.B expecTerm 
introduces five new commands:
.IP
.I emulate 
adds terminal emulation to an existing spawned process
.IP
.I screen_info 
returns information about an emulator's screen and cursor
.IP
.I set_master
controls which emulator the user is viewing
.IP
.I status_line
displays a message on expecTerm's status line
.IP
.I term_info
acceses terminfo capabilities and may issue them to the terminal
.IP
.I term_switch
provides access to terminal switches such as echo and logging.
.PP
.B expecTerm 
adds several new options to the 
.I expect 
command to support screen-based pattern matching.  These are described 
in the COMMANDS section below.
.PP
The 
.I spawn 
command has been given one additional option,
.I \-pipe,
which causes the processes to be established using pipes rather than pseudo 
ttys.  This feature is useful when applications require more spawned 
processes than available pseudo ttys, and the spawned processes 
do not require full pseudo tty support.
.PP
The timeout command has also been changed to accept a 
decimal argument for time, e.g. 
.I set timeout 0.5.
The following simple script illustrates the use of terminal emulation in
.B expecTerm:

.nf
     spawn csh
     emulate -term vt100
     send who\\n
     expect -cols 0:3 jcr2 {puts stdout "jcr2 is logged in"}
.fi

This script
spawns a csh process and connects it to a vt100
emulation. It then sends the the process the command to run the 
.I who 
program 
which will display a list of current system users. The 
.I expect
line then scans for the string "jrc2" to appear in the first 4 columns in
any of the rows on the screen.

Pattern matching on emulated screens occurs at distinct break points,
rather than after every new character (as in normal 
.B expect).
Distinct break points normally occur when the input buffer is full, or
the input stream is empty.  This behavior can be modified with the
.I term_switch 
command to make breaks also occur whenever the cursor moves
backwards or up on the screen.

.SH USAGE
For general usage information see the 
.B expect
manpage.   The rest of this document assumes the reader is familiar with
.B expect
and its suite of commands.


.SH COMMANDS
.B emulate
[
.I -i spawn_id
] [[
.I -term
] 
.I term_type
]
.IP
When a terminal type is specified on the command line,
.I emulate
creates a terminal emulator and associates it with 
the current spawn_id (or the spawn_id specified with 
.I \-i).  With no term_type argument
.I emulate
returns the name of the terminal being emulated.
Any terminal can be emulated provided the system
has the necessary terminfo or termcap data (but see the Caveat section
about non-invertible screen commands).  
.I emulate
always returns the name of the terminal type being emulated.

.I emulate
can also be used to change the terminal type of a spawned process
by simply invoking it again with a new term_type.

.PP
.B expect
[[
.I \-opts
] 
.I patlist1 body1
] ... [
.I \-opts
] 
.I patlistn 
[
.I bodyn
]
.IP
In addition to its standard behavior,
.I expect
has several new options that modify its handling of screen-based patterns.  
As with other 
.I expect
arguments, these options modify the processing of the patterns they
immediately precede.

.I  \-serial, \-scr, \-attr

These options specify whether scanning is to be done over the raw serial
input ( 
.I \-serial
) the screen contents ( 
.I \-scr
), or the screen attributes ( 
.I \-attr
).  The default is serial scanning ( 
.I \-serial
) which tells 
.I expect 
to ignore terminal emulation completely and operate directly 
on the current input stream, i.e. the normal 
.I expect 
behavior.  

If  
.I \-scr 
(or
.I \-screen
) appears before a pattern, scanning will be done on the
emulated screen's contents.   
.I \-scr 
is not necessary if any of the
other screen options described below appear before the
pattern.

.I \-attr
(or
.I \-attributes
) causes pattern matching to be done over the attributes of the characters on
the screen, rather than the characters themselves.  Each character is
associated with a single code representing information about the
character's display attributes.  The codes are listed below in order of
descending dominance:

.nf
  'P' \= PROTECT
  'I' \= INVISIBLE
  'N' \= NORMAL
  'B' \= BOLD
  'S' \= STANDOUT
  'U' \= UNDERLINE
  'A' \= ALTCHARSET
  'R' \= REVERSE
  'D' \= DIM
  'b' \= BLINK
.fi

If a character has two or more attributes, only the most dominant
attribute is available for scanning.  For example, if a character is
both BOLD and REVERSE it will have an attribute code of B.

Here are some simple examples:

.nf
     expect BB
     expect -scr BB
     expect -attr BB
.fi

The first command waits for two subsequent B's on the serial input
(the optional  
.I \-serial 
flag has been omitted).
The second waits for two adjacent B's anywhere on the screen. Note
that the first command will not always match when the second command
matches, e.g if the two B's are not displayed one right after the
other.  The last command scans for two adjacent bold characters
anywhere on the screen.

.I "\-rows, \-cols"

 
.I \-rows 
and  
.I \-cols 
define the screen region to be scanned during
pattern matching.  Each option requires an argument of the form n:n,
where each n is a number (positive or negative) or a '$'.
When used, a '$' 
is translated into either the number of rows or the number of columns on
the emulated screen (depending upon whether  
.I \-rows 
or  
.I \-cols 
is used).

The first number in the n:n form defines the beginning of the scan
region and is always required.  The last number specifies the end of
the scan region and is optional -- if unspecified it defaults to the
first number.  When the last number is not given, the ':' should not
be specified.  The last number should be equal to or greater than the
first number, otherwise the defined screen region will be empty.

The coordinate system is zero-based with 0,0 representing the upper
left corner of the screen, i.e., "-rows 0 -cols 0" specifies the
first character in the first row.  Negative numbers may be used to
define regions counting backward from the last row or last column.
For example, -rows -1 indicates the last row; -rows -2:-1 indicates the last
two rows.

 
.I \-rows 
and  
.I \-cols 
are optional.  If neither is given, the scanning
region defaults to all rows and all columns.  If only one is given,
the other dimension defaults to all rows or all columns.   Whenever possible
it is advisable to specify the smallest necessary screen region (rather than
using the full-screen defaults), as this will improve performance.

When the screen region consists of multiple rows the ends of
the rows are explicitly indicated by newline characters (\\n).
Patterns can span multiple rows by matching \\n.

Examples:

.nf
     expect -rows 0:9 -cols 5 "a"
     expect -cols 5:$ "ab"
     expect -rows -5:-1 "ab"
     expect -rows 0:1 -cols 0:4 "aaaaa\\nbbbbb"
.fi

The first command scans a region covering the first ten rows made up
of the sixth character in each row.  The second command scans a region
spanning columns six through the end of the line over all rows.  The
third command scans a region spanning all columns in the last five
rows.  The last command looks for "aaaaa" in the first five columns of
the first row and "bbbbb" in the first five columns of the second row.

.I "\-rrows, \-rcols"

 
.I \-rrows 
and  
.I \-rcols 
are just like  
.I \-rows 
and  
.I \-cols 
except they specify
screen regions relative to the current cursor location.  Like  
.I \-rows
and  
.I \-cols, 
each takes an argument of the form n:n.  If the second
number is not given it defaults to the first.

The relative coordinate system is zero-based from the cursor
location.  For example, "-rrows 0 -rcols 0" specifies the character location of
the cursor.  Negative numbers define regions counting backward from
the cursor (e.g. -rrows -1 indicates the row above the row the cursor is on).

 
.I \-rrows 
and  
.I \-rcols 
can be intermixed with  
.I \-rows 
and  
.I \-cols.  
If a
dimension is unspecified it defaults to its absolute behavior (either
 
.I \-rows 
or  
.I \-cols
).  Examples:

.nf
     expect -rrows -1:1 -rcols 0:5
     expect -rrows 0
.fi

The first command scans the three rows centered on the cursor,
matching characters from the cursor's column to five columns past the
cursor. The second command scans all columns on the cursor's row.

.I \-quiet n

This option indicates that 
.I n
seconds of quiet time (i.e. no activity on the input stream) must pass before
the pattern can match.  
.I n
may be a floating point number. 
The quiet timer starts when the expect command is
executed.  Consequently, at least 
.I n 
seconds will pass before a match 
is possible, even if the input stream was quiet for some time before the 
command. This option is useful for ensuring that all
changes have been made to the screen before matching a pattern and executing
its command body. 

.I \-quiet_total n

This option is similar to 
.I \-quiet 
except the quiet timer looks back in time prior to the invocation of the
.I expect
command.  As a result, a pattern with a
.I \-quiet_total n
specification can match in less than
.I n
seconds (e.g. immediately) if the input stream had been quiet before the call to  
.I expect.  

.I \-quiet_after_noise n

This option tells 
.I expect
to wait for some initial activity on the input stream followed by
.I n
seconds of quiet.
.I n
may be a floating point number. 
This feature is useful when waiting for some response from a process that may
require time to finish writing to the screen.

.I \-nobreaks 

This option says that pattern matching should NOT be performed when
the cursor moves backwards or up on the screen.  It is only useful when
the term_switch 
.I all_breaks 
is on.

.PP
.B screen_info
[
.I -i spawn_id
] [
.I options
]
.IP
.I screen_info 
provides information about the current state of
a process's emulated screen. If no options are specified, 
.I screen_info 
returns a copy of
the entire contents of the emulated screen, encoded as a
string with newline characters (\\n) separating rows.

.I screen_info 
understands the "screen region" options described above,
e.g.  
.I \-rows,  
.I \-cols, 
.I \-rrows,  
.I \-rcols,  
.I \-attr.  
In addition, it accepts
the following options for obtaining terminal-specific information:

.I \-cursor_row
returns the row the cursor is on.

.I \-cursor_col
returns the column the cursor is on.
 
.I \-nocase
like the \ 
.I -nocase 
option in expect, this modifies a screen region query
such that the returned string is all lower case.

.I \-numrows
returns the number of rows on the emulated terminal.

.I \-numcols
returns the number of columns on the emulated terminal.

If more than one option is specified, the result is a list of the
individual return values, given in the order in which they were specified on
the command line.

.PP
.BI set_master 
[
.I \-i spawn_id 
| 
.I \-next 
|  
.I \-previous
] [
.I \-refresh
]
.IP
While multiple emulations may be running simultaneously, only one
at a time can be viewed on the user's screen.
.I set_master
switches the view to a specific emulator. With no arguments
.I set_master
sets the view to the emulator associated with the current spawn_id.
.I \-next 
and 
.I \-previous 
switch the view to the next or previous emulator,
where the ordering is based on the spawn_id. 
.I \-refresh 
refreshes
the display of the emulator.

.PP
.BI term_info 
[
.I \-i spawn_id 
] [
.I \-transmit | \-type | \-local
]
.I capbilities
+
.IP
In addition to escape sequences to output, the terminfo database also describes
boolean, numeric and string capablities for a terminal.
.I term_info
provides access to this information.
.I capablities
specify the terminfo capability names to be accessed by this function.  If
.I \-transmit
,
.I \-type
or
.I \-local
are specified, string capability bindings will be sent to the terminal.

If 
.I \-transmit
was specified, the string capabilites will be sent directly to the terminal.

If
.I \-type
was specified, the string capabilities bindings will be typed as if from
the keyboard.

If
.I \-local
was specified the string capabilities bindings will be issued locally.  

These switches correspond to 
.I pfx
,
.I pfkey
and
.I pfloc
capabilites in terminfo.  See the terminfo manpage for more detail.

.I term_info
returns a list of the capability bindings for the terminal.  For function
keys bound with pfx or pfloc, the binding will be {-transmit <binding>} or
{-local <binding>} respectively.

Example:

To get terminfo's lines and cols:
.nf
	> term_info -i 5 lines cols
	{24 80}

.fi
To send press function key 2:
.nf
	> term_info -i 5 -type kf2	
	{-transmit ^\[2x}
.fi
.PP
.BI status_line 
[
.I -i spawn_id
] [
.I \-none
| 
.I \-default 
| 
.I \-message string 
] [
.I \-refresh
]"
.IP
.I status_line
allows the user to display a message on the status line of the
emulated terminal.  This line is not part of the emulated screen --
it is not seen by any of the scanning commands.  It is purely for the
benefit of the user monitoring the screen.  With no arguments
.I status_line
returns the the state of the status line, either 
\-default, \-none, or \-message string.
 
.I \-none
sets the status line to nothing, i.e. blank.  
.I \-default 
sets the status line to its default message which contains
information about the state of the terminal in the following format: 
.nf
     Flags: cetrl Session:0/0 Master:3/3 x:00 y:00 vt100
.fi
The flags are upper (on) or lower (off) case letters indicating the state of 
the crnl (c), echo (e), tabspace (t), rawlog (r), and log (l) switches.

The 
.I \-message 
option tells
.I status_line
to put the corresponding string into the status line. The  
.I \-refresh 
argument
causes the status line to be updated on the screen.  For example:

.nf
     status_line -refresh -message "type: [screen_info -term]"
.fi

produces a status line of the following form:

.nf
     type: vt100 
.fi

.PP
.BI term_switch 
[
.I -i spawn_id
] [
.I switch_option
] [
.I -refresh
] [
.I \-log 
[
.I args
]] [
.I \-rawlog 
[
.I args
]]
.IP
.I term_switch 
allows the user to query and set switches controlling the behavior of
an emulated terminal.  The state of these switches are sometimes important for
the proper handling of certain programs (for example vi requires  
that the emulator's crnl switch be "on").
The options that control these switches are: 

.I \-echo
controls whether typed characters are echoed when the user is
interacting with the emulated screen. Default is 0 (off).

.I \-crnl
controls whether end of the line is indicated by 
carriage-return/newline (on) or just carriage-return (off). Default is 0 (off).

.I \-tabspace
controls whether tabs are handled as spaces (on) or tabs (off). Default is 0 (off).

.I \-all_breaks 
controls whether pattern matching occurs at all
distinct breaks (on) or only if the input buffer is full or empty
(off).  With
.I \-all_breaks
on, distinct breaks occur when 1) the cursor moves backwards, 2)
the input buffer is full, or 3) the input buffer is empty. Default is 0 (off).

The above four switches are controlled with one of the following optional
arguments:  
.I \-on 
turns the switch on,  
.I \-off 
turns the switch off,
.I \-toggle 
toggles the switch state, 
.I \-get 
queries the switch's state.
If no argument is given for a switch it defaults to 
.I \-get.  
Whichever argument is used, the command always returns the
new value of the switch, either 1 for "on" or 0 for "off".  

.I \-refresh
This option refreshes the display of the emulated screen.  It's
most useful in combination with other switches when the effect of the
changed switch needs to be displayed right away.

.I \-log, \-rawlog
These options control the logging of the screen information to a file. Logging
is off by default. When turned on using 
.I \-log, 
information about the appearance of the screen is sent to the file whenever
 the screen scrolls or is updated.
With 
.I \-rawlog, 
the raw input (including
control characters) is sent to the file whenever new input arrives.

The \-log options take the same optional arguments as the other switches.
It also understands the following additional arguments:

.I \-append
appends the logging information to an existing file rather than overwriting it.

.I \-file 
specifies the name of the file to log to.  If this option is omitted the
filename defaults to ExpectLog.Spawn_id or ExpectLog.rawSpawn_id,
depending upon whether 
.I \-log 
or  
.I \-rawlog is used.

Multiple switches can be set or queried within a single 
.I term_switch 
command, in which case a list of switch values is returned. For example,

.nf
     term_switch -echo -crnl -off
.fi

returns a list of two values, the state of the echo switch and 
the state of the crnl switch.

The default values for these switches are defined by global variables
described in the VARIABLES section below.  In all cases 0 \= off and 1
\= on.

.SH VARIABLES

.PP
.I expect_out(n,row), expect_out(n,col) 

These are two new elements of the 
.I expect_out 
associative variable that
contains information on the most recently matched patterns.  These elements
return the row or column number of the first character in the matched
pattern.  
.I n 
refers to the number of the pattern of interest, which typically
will be 0 unless regular expressions are used (see the
.B expect 
manpage for more information pattern numbers).

.PP
.I term_type
This variable specifies the terminal type to use if none is specified in an
.I emulate
command.  The initial value of
.I term_type
is vt100.

.PP
.I term_echo
This variable defines the default for the echo switch.  Its
initial value is 0 (off).

.PP
.I term_crnl
This variable defines the default for the crnl switch.  Its
initial value is 0 (off).

.PP
.I term_tabspace
This variable defines the default for the tabspace switch.  Its
initial value is 0 (off).

.PP
.I term_breaks
This variable defines the default for the all_breaks switch.  Its
initial value is 0 (off), meaning pattern matching occurs when the 
(1) input buffer is full, (2) the input buffer is empty, but NOT
(3) when the cursor moves up or backwards.

.SH CAVEATS

Some terminals have escape sequences that are not invertible from the
terminfo or termcap data.  To make the terminal handle these cases
properly, a set of translations need to be defined in the file
ExpectCap (usually kept in /usr/local/lib/expect).  This file has a
similar format to the terminfo database (see the manpage for terminfo
for how to construct this file).
The entries in ExpectCap will override those
from terminfo.  Single terminal entries may be specified in a file
named ExpectCap.<terminal> (e.g. ExpectCap.vt100) which will override
ExpectCap for a particular terminal.  

If stray escape characters appear on the screen or if the screen
appears different from what it does outside of 
.I expecTerm, 
additional
ExpectCap entries are probably required.  Many screen problems are
caused when the terminfo specifies the same escape sequence for
different actions and the emulator, forced to choose, picks the wrong
one.

ExpectCap may contain any valid terminfo capability.  In addition, a NOOP
capability is defined which does nothing.  This may be used to quiet
unrecognized sequences that don't do anything useful.

The ExpectCap file provided with
.B expecTerm
contains entries for vt100 and xterm.

.SH SEE ALSO
.BR Tcl (3),
.BR expect (3),
.BR terminfo (3),
.BR termcap (3),
.BR curses (3)

.SH AUTHORS OF EXPECTERM

Mark D. Weissman, GTE Laboratories Incorporated 
.br
Christopher J. Matheus, GTE Laboratories Incorporated

.SH AUTHOR OF EXPECT
Don Libes, National Institute of Standards and Technology

.SH ACKNOWLEDGMENTS
.PP
Design and implementation of
.B expect
was paid for by the U.S. government and is therefore in the public
domain. However the author and NIST would like credit
if this program and documentation or portions of them are used.
.PP
Design and implementation of
.B expecTerm
was paid for by GTE Laboratories Incorporated which owns the copyright. 
The use of this program, however, is extended freely and without warranty
to the public as specified in the copyright statement.
