/* expect.h - include file for using the expect library, libexpect.a
***************************************************************************** 
expecTerm version 1.0 beta
Mark Weissman
Christopher Matheus
Copyright 1992 by GTE Laboratories Incorporated.

Portions of this work are in the public domain.  Permission to use,
copy, modify, and distribute this software and its documentation for
any purpose and without fee is hereby granted, provided that the above
copyright notice appear in all copies and that both the copyright
notice and warranty disclaimer appear in supporting documentation, and
that the names of GTE Laboratories or any of their entities not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

GTE disclaims all warranties with regard to this software, including
all implied warranties of merchantability and fitness for a particular
purpose, even if GTE Laboratories Incorporated knows about the
purpose.  In no event shall GTE be liable for any special, indirect or
consequential damages or any damages whatsoever resulting from loss of
use, data or profits, whether in an action of contract, negligence or
other tortuous action, arising out of or in connection with the use or
performance of this software.

This code is based on and may include parts of Don Libes' expect code:
  expect written by: Don Libes, NIST, 2/6/90
  Design and implementation of expect was paid for by U.S. tax
  dollars.  Therefore it is public domain.  However, the author and NIST
  would appreciate credit if this program or parts of it are used.
******************************************************************************


Written by: Don Libes, libes@cme.nist.gov, NIST, 12/3/90
Modified by: Mark Weissman 9/92

Design and implementation of this program was paid for by U.S. tax
dollars.  Therefore it is public domain.  However, the author and NIST
would appreciate credit if this program or parts of it are used.
*/

#include <stdio.h>
#include <setjmp.h>

/* return values */
/* -1 is reserved for system errors */
#define EXP_TIMEOUT			-2
#define EXP_EOF				-3

struct exp_case {		/* case for expect command */
	char *pattern;		/* if pattern not in list */
	int value;		/* value to be returned upon match */
};

#ifdef __cplusplus
extern "C" {
#endif

extern char *exp_match;
extern int exp_match_max;		/* bytes */
extern double exp_timeout;	/* seconds */	/* MDW: Mon Jun 22 14:40:24 1992 */
extern int exp_pid;			/* process-id of spawned process */
extern int exp_autoallocpty;		/* if TRUE, we do allocation */
extern int exp_pty[2];			/* master is [0], slave is [1] */
extern char *exp_stty;			/* args to stty to initialize pty */
extern int exp_disconnected;		/* proc. disc'd from controlling tty */

extern jmp_buf exp_readenv;		/* for interruptable read() */
extern int exp_reading;			/* whether we can longjmp or not */

extern int exp_logfile_all;
extern int exp_loguser;
extern int exp_is_debugging;
extern FILE *exp_debugfile;
extern FILE *exp_logfile;

/* support for Standard C and C++ prototypes */
#ifdef __cplusplus
#define EXP_PROTOTYPES
#define EXP_VARARGS	...
#else
#define EXP_VARARGS	, ...
#ifdef __STDC__
#define EXP_PROTOTYPES
#endif
#endif

#ifdef EXP_PROTOTYPES
#define EXP_PROTO(x)	x
#ifdef EXP_DEFINE_FNS
/* when functions are really being defined, we have to use va_alist as arg */
#define EXP_PROTOV(x)	va_alist
#else
#define EXP_PROTOV(x)	x
#endif
#else
#define EXP_PROTO(x)	()
#define EXP_PROTOV(x)	()
#endif

/* Put double parens around macro args so they all look like a single arg */
/* to preprocessor.  That way, don't need a different macro for functions */
/* with a different number of arguments. */

extern int exp_disconnect EXP_PROTO(());
extern FILE *exp_popen	EXP_PROTO((char *command));

#ifndef EXP_DEFINE_FNS
extern int exp_spawnl	EXP_PROTOV((char *file EXP_VARARGS));
extern int exp_expectl	EXP_PROTOV((int fd EXP_VARARGS));
extern int exp_fexpectl	EXP_PROTOV((FILE *fp EXP_VARARGS));
#endif

extern int exp_spawnv	EXP_PROTO((char *file, char *argv[]));
extern int exp_expectv	EXP_PROTO((int fd, struct exp_case *cases));
extern int exp_fexpectv	EXP_PROTO((FILE *fp, struct exp_case *cases));

#ifdef __cplusplus
}
#endif

