#!../natclsh

source ../narray.tcl

proc run body {
    if {[catch [list uplevel $body]] == 1} {
	global errorInfo
	puts stderr $errorInfo
    }
}

proc vtime {msg t_var body} {
    upvar $t_var t
    puts "### $msg"
    puts [set t [time [list uplevel $body]]]
    set t [lindex $t 0]
}

run {
    if {$argc == 0} {
	puts stderr "usage: $argv dim0 ?dim1 ...?"
	return
    }
    set dims $argv
    set n 1
    foreach d $dims {
	set n [expr $d * $n]
    }

    vtime "Testing C" t_c {
	puts [eval [concat exec ./t1 $dims]]
    }
    puts "approximately [expr 1.0 * $t_c / $n] usecs/array elt"
    puts "   or [expr 1.0e3 * $n / $t_c] K-elts/sec"
    
    vtime "Testing narray" t_narray {
	eval [concat narray create m $dims]
	m vset sum 0
	m map { sum += $[]; }
	puts "Sum: [m vref sum]"
	puts "Status: [m status]"
    }
    puts "approximately [expr 1.0 * $t_narray / $n] usecs/array elt"
    puts "   or [expr 1.0e3 * $n / $t_narray] K-elts/sec"
    puts "t_narray / t_c = [expr double($t_narray) / $t_c]"

    if 0 {
    vtime "Testing Scheme (using scm)" t_scm {
	puts [eval [concat exec scm t1.scm $dims < /dev/null]]
    }
    puts "approximately [expr 1.0 * $t_scm / $n] usecs/array elt"
    puts "   or [expr 1.0e3 * $n / $t_scm] K-elts/sec"
    puts "t_scm / t_narray = [expr 1.0 * $t_scm / $t_narray]"
    }
    
}
