source narray.tcl

proc msg {msg} {
    puts "### $msg"
}

proc run body {
    if {[catch [list uplevel $body]] == 1} {
	global errorInfo
	puts stderr $errorInfo
    }
}

set debug 4

run {
    msg "Making f a 20x20 matrix"
    narray create f 20 20
    f debug $debug
    puts [string trim [f status]]

    msg "Setting matrix to floor(10 * sin(x * y))..."
    f map {
	[] = floor(10 * sin(@0 * @1));
    }

    msg "Result:"
    pnarray f

    set out test_printf.out
    set fp [open $out w]
    msg "Printing result using tcl_eval to $out"
    f map {
	if @0 == 0 {
	    tcl_eval("puts $fp {}");
	}
	tcl_eval("puts -nonewline $fp [format \"%3.f \" ", $[], "]");
    }
    close $fp
}
