# mkListbox w
#
# Create a top-level window that displays a listbox with the names of the
# 50 prefectures.
#
# Arguments:
#    w -	Name to use for new top-level window.
#
# modified by k.furukawa, apr.1993. for 16bit kanji font

proc mkListbox {{w .l1}} {
    catch {destroy $w}
    toplevel $w
    dpos $w
    wm title $w "Listbox Demonstration (46 prefectures)"
    wm iconname $w "Listbox"
    wm minsize $w 1 1

#    option add *Listbox.font k14

    message $w.msg -font k14 -aspect 300 \
	    -text "ܤΣ̾ΥСդΥꥹȥܥåɽƤޤꥹȤƤϥСȤꥹȥܥåޥܥ󣲤ǥɥå뤳ȤˤäĴ٤뤳ȤǤޤʬƣϣˡǥܥ򥯥åƲ"
    frame $w.frame -borderwidth 10
    scrollbar $w.frame.scroll -relief sunken -command "$w.frame.list yview"
    listbox $w.frame.list -yscroll "$w.frame.scroll set" -relief sunken \
	    -setgrid 1 -font k14
    pack append $w.frame $w.frame.scroll {right filly} \
	    $w.frame.list {left expand fill}
    $w.frame.list insert 0 ̳ƻ Ŀ   ܾ  ʡ \
	       \
	 ٻ  ʡ Ĺ    Ų  \
	    ²λ\
	ʼ Ļ 纬   \
	 ɲ  \
	ʡ  Ĺ ʬ  \
	
    button $w.ok -text ϣ -font k14 -command "destroy $w"

    pack append $w $w.msg {top fill} $w.frame {top expand filly frame center} \
	$w.ok {bottom fill}
}
