/* -*-Mode: C;-*- delete.c -[Fri Oct  9 11:29:28 1992 by cxh]- */
#ifndef lint
static char     rcsid[] = "$Id: sql.sc,v 1.4 1992/09/29 21:20:13 cxh Exp cxh $";
#endif
/*
 * Copyright 1992 Regents of the University of California. Permission to use,
 * copy, modify, and distribute this software and its documentation for any
 * purpose and without fee is hereby granted, provided that the above
 * copyright notice appear in all copies.  The University of California makes
 * no representations about the suitability of this software for any purpose.
 * It is provided 'as is' without express or implied warranty.
 */

/*
 * This file consists of the sql specific code.  This file contains embedded
 * sql, it should be converted to a .c file by Ingres' esql. The functions at
 * the bottom are externally visible.
 */

#include "tclsql.h"
#include "coltype.h"

/* Include the sql communications area. */
EXEC SQL INCLUDE SQLCA;

/* Include the global data location typdef. */
EXEC SQL INCLUDE SQLDA;

/* curs.h must be included _after_ INCLUDE SQLCA and SQLDA */
#include "curs.h"


/*
 * Called by SQLdeleteCursor tablename cursor_name
 */
delete_cursor(interp, tabname, cursor_name)
     Tcl_Interp     *interp;
     char           *tabname;
     char           *cursor_name;
{
  EXEC SQL BEGIN DECLARE SECTION;
  char            esqlcmd[BUFSIZ];
  EXEC SQL END DECLARE SECTION;
  CURSOR         *cursor;

  if ((cursor = get_cursor(cursor_name)) == NULL) {
    Tcl_AppendResult(interp, "SQLdelete", tabname, " ", cursor_name,
		     " Trouble converting ", cursor_name,
		     " to cursor structure.", 0);
    return TCL_ERROR;
  }

  sprintf(esqlcmd, "delete from %s where current of %s", tabname, cursor->name);
  EXEC SQL WHENEVER SQLERROR GOTO delete_err;
  EXEC SQL execute immediate:esqlcmd;

  return TCL_OK;
delete_err:
  EXEC SQL WHENEVER SQLERROR CONTINUE;
  sql_error(interp, esqlcmd);
  return TCL_ERROR;
}
