#---------------------------------------------------------------------------
#
#	Paned Windows a la OSF/Motif
#
#---------------------------------------------------------------------------

defwidget Panes Window {{dist 0.05} {sep 0.02}}

defmethod Panes new {name args} {

  args	{panes 2} {width 300} {height 400} init layout {direction vertical}

  if { $direction == "horizontal" } {
    set vertical 0
  } {
    set vertical 1
  }

  Frame new $name -layout [concat $layout fill expand] \
	-width $width -height $height
  defsuper $name Panes
  $name slot vertical $vertical

  bind $name <Configure> "+ $name _resize"

  $name slot panes $panes
  $name slot frac0 0

  set panespace [expr 1.0-($panes-1)*[$self slot sep]]

  for {set i 1} {$i <= $panes} {incr i} {

    Frame new $name.pane$i -relief flat

    if { $init == "label" } {
      Label new $name.pane$i.l -text "Pane $i"
      place $name.pane$i.l -in $name.pane$i -x 0 -y 0
    } elseif { $init != {} } {
      eval [concat $init $name.pane$i $i]
    }

    if { $i < $panes } {
      if { $vertical } {
	Canvas new $name.sep$i -height 8 -relief flat
	bind $name.sep$i <Button-1> "$name _start $i %Y"
	bind $name.sep$i <B1-Motion> "$name _movey $i %Y"
	bind $name.sep$i <B1-ButtonRelease-1> \
	  "$name slot frac$i \[$name slot tmp\]; $name _arrange"
      } {
	Canvas new $name.sep$i -width 8 -relief flat
	bind $name.sep$i <Button-1> "$name _start $i %X"
	bind $name.sep$i <B1-Motion> "$name _movex $i %X"
	bind $name.sep$i <B1-ButtonRelease-1> \
	  "$name slot frac$i \[$name slot tmp\]; $name _arrange"
      }
    }

    $name slot frac$i [expr $i.0/$panes]
    $name slot start$i 0
  }

  $name _arrange
  update
  $name _resize
  return $name
}

defmethod Panes _start {i coord} {

  $self slot tmp [$self slot frac$i]
  $self slot start $coord.0
}

defmethod Panes _movex {i x} {

  set width [winfo width $self]
  set prev [expr $i-1]
  set next [expr $i+1]

  set dist [Panes slot dist]
  set sep [Panes slot sep]

  set lower [expr [$self slot frac$prev]+$dist]
  set upper [expr [$self slot frac$next]-$dist]

  set xfrac [expr ($x-[$self slot start])/$width+[$self slot frac$i]]
  if { $xfrac < $lower } {
    set xfrac $lower
  } elseif { $xfrac > $upper } {
    set xfrac $upper
  }

  place $self.sep$i -in $self -y 0 \
	-relx [expr $xfrac-$sep] \
	-relwidth $sep \
	-relheight 1.0

  $self slot tmp $xfrac
}

defmethod Panes _movey {i y} {

  set height [winfo height $self]
  set prev [expr $i-1]
  set next [expr $i+1]

  set dist [Panes slot dist]
  set sep [Panes slot sep]

  set lower [expr [$self slot frac$prev]+$dist]
  set upper [expr [$self slot frac$next]-$dist]

  set yfrac [expr ($y-[$self slot start])/$height+[$self slot frac$i]]
  if { $yfrac < $lower } {
    set yfrac $lower
  } elseif { $yfrac > $upper } {
    set yfrac $upper
  }

  place $self.sep$i -in $self -x 0 \
	-rely [expr $yfrac-$sep] \
	-relheight $sep \
	-relwidth 1.0

  $self slot tmp $yfrac
}

defmethod Panes _arrange {} {

  set sep [Panes slot sep]
  set panes [$self slot panes]

  if { [$self slot vertical] } {
    for {set j 0; set i 1} {$i <= $panes} {incr i; incr j} {
      set fj [$self slot frac$j]
      place $self.pane$i -in $self -x 0 \
	-rely $fj \
	-relheight [expr [$self slot frac$i]-$fj-$sep] \
	-relwidth 1.0
    }
    for {set i 1} {$i < $panes} {incr i} {
      place $self.sep$i -in $self -x 0 \
	-rely [expr [$self slot frac$i]-$sep] \
	-relheight $sep \
	-relwidth 1.0
    }
  } {
    for {set j 0; set i 1} {$i <= $panes} {incr i; incr j} {
      set fj [$self slot frac$j]
      place $self.pane$i -in $self -y 0 \
	-relx $fj \
	-relwidth [expr [$self slot frac$i]-$fj-$sep] \
	-relheight 1.0
    }
    for {set i 1} {$i < $panes} {incr i} {
      place $self.sep$i -in $self -y 0 \
	-relx [expr [$self slot frac$i]-$sep] \
	-relwidth $sep \
	-relheight 1.0
    }
  }

  return $self
}

defmethod Panes _resize {} {

  set col [Color slot bg,button]

  if { [$self slot vertical] } {
    set width [winfo width $self]
    for {set i 1} {$i < [$self slot panes]} {incr i} {
      $self.sep$i! delete items
      $self.sep$i! create line 0 4 $width 4 \
	-tags items -width 2
      $self.sep$i! create rectangle 10 1 17 7 \
	-fill $col -tags items
      $self.sep$i! create rectangle [expr $width-20] 1 [expr $width-13] 7 \
	-fill $col -tags items
    }
  } {
    set height [winfo height $self]
    for {set i 1} {$i < [$self slot panes]} {incr i} {
      $self.sep$i! delete items
      $self.sep$i! create line 4 0 4 $height\
	-tags items -width 2
      $self.sep$i! create rectangle 1 10 7 17 \
	-fill $col -tags items
      $self.sep$i! create rectangle 1 [expr $height-20] 7 [expr $height-13] \
	-fill $col -tags items
    }
  }
}

defmethod Panes frame {i} {
  return $self.pane$i
}

Window addDemo Panes

defmethod Panes demo {} {

  set t [Toplevel new * -title "New Toplevel" -info true -resizable true]
  Button new *$t -layout {padx 20 pady 20 bottom} \
	-textfont largebold -text "Dismiss" \
	-action [list $t Dismiss]
  Panes new *$t -panes 4 -init label -layout left -direction horizontal
  Panes new *$t -panes 4 -init label -layout left -direction vertical
  $t layout center
}
