#---------------------------------------------------------------------------
#
#	Scale Widgets
#
#---------------------------------------------------------------------------

defwidget Scale

defmethod Scale new {name args} {

  args	layout action {range {0 100}} {direction horizontal} label \
	{labelfont smallbold} {size 200} width

  if { $width == {} } {
    set width [expr $size/10]
    if { $width > 30 } {
      set width 30
    }
  }

  scale $name \
	-relief flat -orient $direction \
	-label $label -font [Font slot $labelfont] \
	-command [list $name action $action] \
	-state normal \
	-width $width -length $size \
	-from [lindex $range 0] -to [lindex $range 1] \
	-activeforeground [Color slot bg,active] \
	-foreground [Color slot fg] \
	-background [Color slot bg] \
	-sliderforeground [Color slot bg,button] \
	-sliderlength 20 \
	
  Scale instantiate $name $layout
}

defmethod Scale action {action value} {

  if { $action != {} } {
    eval [concat $action [list $value]]
  }
}

#---------------------------------------------------------------------------

bind Scale <Any-Enter> {}
bind Scale <Any-Leave> {}

bind Scale <Any-ButtonPress> {incr tk_priv(buttons)}
bind Scale <Any-ButtonRelease> {incr tk_priv(buttons) -1}
