#include <stdio.h>
#include <gl.h>
#include <math.h>


static Angle ang;

glxtst_var_init()
{
  static int initted = 0;
  if(!initted){
    /* init any important data structures */
    
    ang = 0;
    initted = 1;
  }
}


glxtst_init()
{
  doublebuffer();
  RGBmode();
  perspective(50, 1.0, 400.0, 600.0);
  lookat(0., 0., 500., 0., 0., 0., 0.);
  
}

glxtst_getviewport(str)
     char *str;
{
  Screencoord l, r, b, t;
  getviewport(&l, &r, &b, &t);
  sprintf(str, "%d %d %d %d\n", l, r, b, t);
}


glxtst_finish()
{
  finish();
}


glxtst_render()
{
  drawscene(ang);
  gflush();
}

glxtst_param(pname, val, set)
     char *pname, *val;
     int set;
{
  if(strcmp(pname, "angle") == 0){
    if(set)
      ang = atoi(val);
    else
      sprintf(val, "%d", ang);
  } 
  else 
    return(1);

  return(0);
}

/* The following as taken verbatim from the "4Dgifts" example program
   /usr/people/4Dgifts/examples/GLX/glxwidget/demos/network.

   Dare to compare GLXMDraw to this approach.
*/

#define RAD(x) ((double) (x * M_PI / 1800))
#define FAR 0x7fff
#define INITIAL_INC 60
#define PULSE 50
#define RADIUS 15

long
    blackcol[3] = {0, 0, 0},
    bluecol[3] = {0, 0, 255},
    greencol[3] = {0, 255, 0},
    yellowcol[3] = {255, 255, 0},
    redcol[3] = {255, 0, 0},
    red2col[3] = {225, 0, 0},
    whitecol[3] = {255, 255, 255},
    purplecol[3] = {160, 30, 120},
    tancol[3] = {214, 196, 171};

long background[3] = {100, 100, 100};


drawscene(ang)
    Angle ang;
{
    pushmatrix();
    c3i(background);
    clear();
    ring(ang);
    workstation(900);
    workstation(2100);
    workstation(3300);
    popmatrix();
    swapbuffers(); 
}


ring(ang)
    int ang;
{
    linewidth(5);
    c3i(yellowcol);
    circ(0, 0, RADIUS);
    c3i(purplecol);
    arc(0, 0, RADIUS, ang-PULSE/2, ang+PULSE/2);
    linewidth(1);
}

vert3f(x, y, z)
    float x, y, z;
{
    float v[3];

    v[0] = x; v[1] = y; v[2] = z;
    v3f(v);
}


workstation(drawang)
    Angle drawang;
{
    float x,y;
    pushmatrix();
    x = (float) cos(RAD(drawang)) * RADIUS;
    y = (float) sin(RAD(drawang)) * RADIUS;
    translate(x, y, 0.);
    rotate(200,'x');
    rotate(300,'y');
    scale(0.3, 0.3, 0.3);
    drawbase();
    drawmonitor(drawang);
    drawkeybd();
    popmatrix();
}

drawbase()
{
/* front of base */
    c3i(tancol);
    bgnpolygon();    
    vert3f(-8., -10., 1.);
    vert3f(8., -10., 1.);
    vert3f(8., -7., 1.);
    vert3f(-8., -7., 1.);
    endpolygon();
    c3i(blackcol);
    bgnclosedline();
    vert3f(-8., -10., 1.);
    vert3f(8., -10., 1.);
    vert3f(8., -7., 1.);
    vert3f(-8., -7., 1.);
    endclosedline();
/* left side of the base */
    c3i(tancol);
    bgnpolygon();    
    vert3f(-8., -10., 1.);
    vert3f(-8., -10., -10.);
    vert3f(-8., -7., -10.);
    vert3f(-8., -7., 1.);
    endpolygon();
    c3i(blackcol);
    bgnclosedline();
    vert3f(-8., -10., 1.);
    vert3f(-8., -10., -10.);
    vert3f(-8., -7., -10.);
    vert3f(-8., -7., 1.);
    endclosedline();
/* top of base */
    c3i(tancol);
    bgnpolygon();
    vert3f(-8., -7., 1.);
    vert3f(-8., -7., -10.);
    vert3f(8., -7., -10.);
    vert3f(8., -7., 1.);
    endpolygon();
    c3i(blackcol);
    bgnclosedline();
    vert3f(-8., -7., 1.);
    vert3f(-8., -7., -10.);
    vert3f(8., -7., -10.);
    vert3f(8., -7., 1.);
    endclosedline();
}

drawmonitor(drawang)
    Angle drawang;
{
/* front of monitor */
    c3i(tancol);
    bgnpolygon();
    vert3f(-8.,8.,1.);
    vert3f(-8.,-6.,1.);
    vert3f(8.,-6.,1.);
    vert3f(8.,8.,1.);
    endpolygon();
    c3i(blackcol);
    bgnclosedline();
    vert3f(-8.,8.,1.);
    vert3f(-8.,-6.,1.);
    vert3f(8.,-6.,1.);
    vert3f(8.,8.,1.);
    endclosedline();
/* top of monitor */
    c3i(tancol);
    bgnpolygon();
    vert3f(-8.,8.,1.);
    vert3f(-7.,7.,-9.);
    vert3f(7.,7.,-9.);
    vert3f(8.,8.,1.);
    endpolygon();
    c3i(blackcol);
    bgnclosedline();
    vert3f(-8.,8.,1.);
    vert3f(-7.,7.,-9.);
    vert3f(7.,7.,-9.);
    vert3f(8.,8.,1.);
    endclosedline();
/* left side of monitor */
    c3i(tancol);
    bgnpolygon();
    vert3f(-8., 8., 1.);
    vert3f(-7., 7., -9.);
    vert3f(-7., -5., -9.);
    vert3f(-8., -6., 1.);
    endpolygon();
    c3i(blackcol);
    bgnclosedline();
    vert3f(-8., 8., 1.);
    vert3f(-7., 7., -9.);
    vert3f(-7., -5., -9.);
    vert3f(-8., -6., 1.);
    endclosedline();
/* screen */
    if (abs(drawang - ang) < 150)
	c3i(purplecol);
    else
	c3i(blackcol);
    bgnpolygon();
    vert3f(-6.,6.,1.);
    vert3f(-6.,-4.,1.);
    vert3f(6.,-4.,1.);
    vert3f(6.,6.,1.);
    endpolygon();
}


drawkeybd()
{
/* side of keybd */
    c3i(tancol);
    bgnpolygon();
    vert3f(-8., -10., 3.);
    vert3f(-8., -10., 10.);
    vert3f(-8., -9., 10.);
    vert3f(-8., -8., 3.);
    endpolygon();
    c3i(blackcol);
    bgnclosedline();
    vert3f(-8., -10., 3.);
    vert3f(-8., -10., 10.);
    vert3f(-8., -9., 10.);
    vert3f(-8., -8., 3.);
    endclosedline();
/* top of keybd */
    c3i(tancol);
    bgnpolygon();
    vert3f(-8., -9., 10.);
    vert3f(-8., -8., 3.);
    vert3f(8., -8., 3.);
    vert3f(8., -9., 10.);
    endpolygon();
    c3i(blackcol);
    bgnclosedline();
    vert3f(-8., -9., 10.);
    vert3f(-8., -8., 3.);
    vert3f(8., -8., 3.);
    vert3f(8., -9., 10.);
    endclosedline();
/* front of keybd */
    c3i(tancol);
    bgnpolygon();
    vert3f(-8., -9., 10.);
    vert3f(8., -9., 10.);
    vert3f(8., -10., 10.);
    vert3f(-8., -10., 10.);
    endpolygon();
    c3i(blackcol);
    bgnclosedline();
    vert3f(-8., -9., 10.);
    vert3f(8., -9., 10.);
    vert3f(8., -10., 10.);
    vert3f(-8., -10., 10.);
    endclosedline();
}

