#include <stdio.h>
#include "tk.h"

extern int simp_render_cmd(), simp_render2_cmd(), simp_clear_cmd(),
  simp_get_value_cmd(), simp_set_value_cmd(), simp_get_mouse_cmd(),
  simp_render_ov_cmd(), simp_render_init_cmd();

extern int simp_set_RGBcolor_cmd(), simp_set_color_cmd(), 
  simp_mapcolor_cmd(), simp_box_cmd();

simp_tcl_init(interp, w)
     Tcl_Interp *interp;
     Tk_Window w;
{

  Tcl_CreateCommand(interp, "render_init", simp_render_init_cmd, NULL, NULL);
  Tcl_CreateCommand(interp, "render", simp_render_cmd, NULL, NULL);     
  Tcl_CreateCommand(interp, "set-value", simp_set_value_cmd, NULL, NULL);     
  Tcl_CreateCommand(interp, "get-value", simp_get_value_cmd, NULL, NULL);     
  Tcl_CreateCommand(interp, "get-mouse", simp_get_mouse_cmd, NULL, NULL);     
  Tcl_CreateCommand(interp, "render2", simp_render2_cmd, NULL, NULL);     
  Tcl_CreateCommand(interp, "renderov", simp_render_ov_cmd, NULL, NULL);     
  Tcl_CreateCommand(interp, "clear", simp_clear_cmd, NULL, NULL);     
  Tcl_CreateCommand(interp, "set_RGBcolor", simp_set_RGBcolor_cmd, NULL, NULL);
  Tcl_CreateCommand(interp, "set_color", simp_set_color_cmd, NULL, NULL);
  Tcl_CreateCommand(interp, "mapcolor", simp_mapcolor_cmd, NULL, NULL);
  Tcl_CreateCommand(interp, "box", simp_box_cmd, NULL, NULL);
}

int simp_render_cmd(dummy, interp, argc, argv)
    ClientData dummy;			/* Not used. */
    Tcl_Interp *interp;			/* Current interpreter. */
    int argc;				/* Number of arguments. */
    char **argv;			/* Argument strings. */
{
  /* one render  */
  simp_render();
  return(TCL_OK);
}

int simp_render_init_cmd(dummy, interp, argc, argv)
    ClientData dummy;			/* Not used. */
    Tcl_Interp *interp;			/* Current interpreter. */
    int argc;				/* Number of arguments. */
    char **argv;			/* Argument strings. */
{
  simp_init();
  return(TCL_OK);
}

int simp_set_RGBcolor_cmd(dummy, interp, argc, argv)
    ClientData dummy;			/* Not used. */
    Tcl_Interp *interp;			/* Current interpreter. */
    int argc;				/* Number of arguments. */
    char **argv;			/* Argument strings. */
{
  simp_set_RGBcolor(atoi(argv[1]), atoi(argv[2]), atoi(argv[3]));
  return(TCL_OK);
}

int simp_box_cmd(dummy, interp, argc, argv)
    ClientData dummy;			/* Not used. */
    Tcl_Interp *interp;			/* Current interpreter. */
    int argc;				/* Number of arguments. */
    char **argv;			/* Argument strings. */
{
  simp_box(atoi(argv[1]), atoi(argv[2]),
		    atoi(argv[3]), atoi(argv[4]));
  return(TCL_OK);
}

int simp_mapcolor_cmd(dummy, interp, argc, argv)
    ClientData dummy;			/* Not used. */
    Tcl_Interp *interp;			/* Current interpreter. */
    int argc;				/* Number of arguments. */
    char **argv;			/* Argument strings. */
{
  simp_mapcolor(atoi(argv[1]), atoi(argv[2]),
		atoi(argv[3]), atoi(argv[4]));
  return(TCL_OK);
}


int simp_set_color_cmd(dummy, interp, argc, argv)
    ClientData dummy;			/* Not used. */
    Tcl_Interp *interp;			/* Current interpreter. */
    int argc;				/* Number of arguments. */
    char **argv;			/* Argument strings. */
{
  simp_set_color(atoi(argv[1]));
  return(TCL_OK);
}

int simp_set_value_cmd(dummy, interp, argc, argv)
    ClientData dummy;			/* Not used. */
    Tcl_Interp *interp;			/* Current interpreter. */
    int argc;				/* Number of arguments. */
    char **argv;			/* Argument strings. */
{
  if(argc != 3){
    sprintf(interp->result, "wrong number of args");
    return(TCL_ERROR);
  }

  simp_set_value(argv[1], argv[2]);
  return(TCL_OK);
}

int simp_get_value_cmd(dummy, interp, argc, argv)
    ClientData dummy;			/* Not used. */
    Tcl_Interp *interp;			/* Current interpreter. */
    int argc;				/* Number of arguments. */
    char **argv;			/* Argument strings. */
{

  simp_get_value(argv[1], interp->result);
  return(TCL_OK);
}

int simp_get_mouse_cmd(dummy, interp, argc, argv)
    ClientData dummy;			/* Not used. */
    Tcl_Interp *interp;			/* Current interpreter. */
    int argc;				/* Number of arguments. */
    char **argv;			/* Argument strings. */
{
  simp_get_mouse(argv[1], interp->result);
  return(TCL_OK);
}

int simp_render2_cmd(dummy, interp, argc, argv)
    ClientData dummy;			/* Not used. */
    Tcl_Interp *interp;			/* Current interpreter. */
    int argc;				/* Number of arguments. */
    char **argv;			/* Argument strings. */
{
  /* one render  */
  simp_render2(atoi(argv[1]), atoi(argv[2]), atoi(argv[3]));
  return(TCL_OK);
}

int simp_render_ov_cmd(dummy, interp, argc, argv)
    ClientData dummy;			/* Not used. */
    Tcl_Interp *interp;			/* Current interpreter. */
    int argc;				/* Number of arguments. */
    char **argv;			/* Argument strings. */
{
  /* one render  */
  simp_render_ov(atoi(argv[1]));
  return(TCL_OK);
}

int simp_clear_cmd(dummy, interp, argc, argv)
    ClientData dummy;			/* Not used. */
    Tcl_Interp *interp;			/* Current interpreter. */
    int argc;				/* Number of arguments. */
    char **argv;			/* Argument strings. */
{
  /* one init  */
  simp_clear();
  return(TCL_OK);
}
