 #########################################################################
 #                                                                       #
 # Copyright (C) 1993 by General Electric company.  All rights reserved. #
 #                                                                       #
 # Permission to use, copy, modify, and distribute this                  #
 # software and its documentation for any purpose and without            #
 # fee is hereby granted, provided that the above copyright              #
 # notice appear in all copies and that both that copyright              #
 # notice and this permission notice appear in supporting                #
 # documentation, and that the name of General Electric not be used in   #
 # advertising or publicity pertaining to distribution of the            #
 # software without specific, written prior permission.                  #
 #                                                                       #
 # General Electric makes no representations about the suitability of    #
 # this software for any purpose.  It is provided ``as is''              #
 # without express or implied warranty.                                  #
 #                                                                       #
 # This work was supported in part by the DARPA Initiative in Concurrent #
 # Engineering (DICE) through DARPA Contracts MDA972-88-C-0047 and       #
 # MDA972-92-C-0027.                                                     #
 #                                                                       #
 # This work was supported in part by the Tri-Services Microwave and     #
 # Millimeter-Wave Advanced Computational Environment (MMACE) program    #
 # under Naval Research Laboratory contract N00014-92-C-2044.            #
 #                                                                       #
 #########################################################################


# File:	int.tcl
#
# Description:
#	Function to convert real to integer

 # $Id: int.tcl,v 1.10 1993/11/01 18:20:46 kennykb Exp $
 # $Source: /homedisk/julius/u0/kennykb/src/tkauxlib_ship/RCS/int.tcl,v $
 # $Log: int.tcl,v $
 # Revision 1.10  1993/11/01  18:20:46  kennykb
 # Beta release to be announced on comp.lang.tcl
 #
 # Revision 1.9  1993/10/27  15:52:49  kennykb
 # Package for alpha release to the Net, and for MMACE 931101 release.
 #
 # Revision 1.8  1993/10/20  19:10:47  kennykb
 # Alpha release #1 was thawed for bug fixes in tk 3.3.  Now frozen again at this
 # point.
 #
 # Revision 1.7  1993/10/20  18:47:15  kennykb
 # Fixed copyright notice so that it doesn't look like structured commentary.
 #
 # Revision 1.6  1993/10/14  18:15:42  kennykb
 # Cleaned up alignment of log messages, to avoid problems extracting
 # structured commentary.
 #
 # Revision 1.5  1993/10/14  18:06:59  kennykb
 # Added GE legal notice to head of file in preparation for release.
 #
 # Revision 1.4  1993/10/14  14:02:02  kennykb
 # Alpha release #1 frozen at this point.
 #
 # Revision 1.3  1993/10/14  13:39:39  kennykb
 # Adjusted to take advantage of Tcl 7.0 function for `integer part'.
 # It helps.  Thanks, John!
 #
 # Revision 1.2  1993/07/21  19:44:36  kennykb
 # Finished cleaning up structured commentary.
 #
 # Revision 1.1  1993/06/03  15:30:10  kennykb
 # Initial revision
 #

# Procedure:	int
#
# Synopsis:
#	Convert a real number to an integer.
#
# Usage:
#c	int number
#
# Parameters:
#c	number
#		Floating point number
#
# Return value:
#	Integer part of `number'.
#
# Description:
#	`int' trims a string representing a floating point number
#	to an integer.
#
# Notes:
#	This function requires either tclX6.5c or later, or else Tcl 7.0
#	or later.
#
# Bugs:
#	This function will become obsolete in Tcl 7.0.

proc int s {
	if {[info tclversion] >= 7.0} {
		return [expr int($s)]
	} else {
		if [regexp {([-+]?[0-9]*)[.][0-9]*} [floor $s] \
						discard integer] {
			return $integer
		} else {
			error "$s not a number or out of range"
		}
	}
}
