 #########################################################################
 #                                                                       #
 # Copyright (C) 1993 by General Electric company.  All rights reserved. #
 #                                                                       #
 # Permission to use, copy, modify, and distribute this                  #
 # software and its documentation for any purpose and without            #
 # fee is hereby granted, provided that the above copyright              #
 # notice appear in all copies and that both that copyright              #
 # notice and this permission notice appear in supporting                #
 # documentation, and that the name of General Electric not be used in   #
 # advertising or publicity pertaining to distribution of the            #
 # software without specific, written prior permission.                  #
 #                                                                       #
 # General Electric makes no representations about the suitability of    #
 # this software for any purpose.  It is provided ``as is''              #
 # without express or implied warranty.                                  #
 #                                                                       #
 # This work was supported in part by the DARPA Initiative in Concurrent #
 # Engineering (DICE) through DARPA Contracts MDA972-88-C-0047 and       #
 # MDA972-92-C-0027.                                                     #
 #                                                                       #
 # This work was supported in part by the Tri-Services Microwave and     #
 # Millimeter-Wave Advanced Computational Environment (MMACE) program    #
 # under Naval Research Laboratory contract N00014-92-C-2044.            #
 #                                                                       #
 #########################################################################


# File:	tkerror.tcl
#
# Description:
#	Background error handler for Tk
#
# Global variables:
#c	tkerror_priv
#		Variable that holds the action requested by the user in
#		response to an error.  May be one of `OK', meaning ignore
#		the error and continue, `terminate', meaning destroy the
#		application, or `abort', meaning destroy the application
#		after producing a dump of the Tcl workspace.
#
# Notes:
#	This file is loaded by `init.tcl'.  Autoloading it does not work.
#	The definition of the `tkerror' function must be present at the
#	time that an error is reported, since otherwise the system default
#	will be used.

 # $Id: tkerror.tcl,v 1.12 1993/11/01 18:20:46 kennykb Exp $
 # $Source: /homedisk/julius/u0/kennykb/src/tkauxlib_ship/RCS/tkerror.tcl,v $
 # $Log: tkerror.tcl,v $
 # Revision 1.12  1993/11/01  18:20:46  kennykb
 # Beta release to be announced on comp.lang.tcl
 #
 # Revision 1.11  1993/10/27  15:52:49  kennykb
 # Package for alpha release to the Net, and for MMACE 931101 release.
 #
 # Revision 1.10  1993/10/21  22:02:06  kennykb
 # Changed tkerror to avoid destroying application on recursive errors.
 # This action tends to be too violent, since recursive errors usually
 # have a single cause and frequently appear as an event queue is being
 # drained while processing the first error.
 #
 # Revision 1.9  1993/10/20  19:10:47  kennykb
 # Alpha release #1 was thawed for bug fixes in tk 3.3.  Now frozen again at this
 # point.
 #
 # Revision 1.8  1993/10/20  19:06:24  kennykb
 # Repaired copyright notice so that it doesn't look like structured commentary.
 #
 # Revision 1.7  1993/10/14  18:15:42  kennykb
 # Cleaned up alignment of log messages, to avoid problems extracting
 # structured commentary.
 #
 # Revision 1.6  1993/10/14  18:06:59  kennykb
 # Added GE legal notice to head of file in preparation for release.
 #
 # Revision 1.5  1993/10/14  14:02:02  kennykb
 # Alpha release #1 frozen at this point.
 #
 # Revision 1.4  1993/10/14  13:46:57  kennykb
 # Changes to (hopefully) avoid use of Tk commands from within a destroyed
 # application.
 #
 # Revision 1.3  1993/07/21  19:44:36  kennykb
 # Finished cleaning up structured commentary.
 #
 # Revision 1.2  1993/07/20  13:12:03  kennykb
 # Made `choicebox', `collapsible', and `debug' conform with naming and
 # commentary conventions.
 #
 # Revision 1.1  1993/06/03  15:32:43  kennykb
 # Initial revision
 #

# Procedure:	tkerror
#
# Synopsis:
#	Report a background error occurring in a Tk callback.
#
# Usage:
#c	tkerror message
#
# Parameters:
#c	message
#		A message describing a background error that has occurred.
#
# Return value:
#	None.
#
# Description:
#	The `tkerror' procedure handles unexpected background error occurring
#	within the Tk application.  It constructs a modal dialog box displaying
#	the error message, and giving the user the options of continuing,
#	terminating, or aborting.

proc tkerror message {
	global tkerror_active
	global tkerror_priv
	global errorCode
	global errorInfo
	global env
	global widget_appDestroyed

	# Stash the original errorInfo and errorCode as quickly as possible

	set info $errorInfo
	set code $errorCode

	# Don't try to report errors in a destroyed application.

	if {[info exists widget_appDestroyed] || [catch {focus}]} {
		puts stderr \
			"Can't process error: application has been destroyed."
		puts stderr \t$message
		return
	}

	# Don't try to report errors recursively.

	if [info exists tkerror_active] {
		puts stderr $message
		puts stderr "   while tkerror was active."
		puts stderr "Attempting to continue...."
		return
	}
	set tkerror_active 1

	set w .[gensym error]
	modalDialog transient choicebox $w \
		-text $message \
		-buttons {\
			OK \
			{Terminate terminate} \
			{{Abort (and dump)} abort}} \
		-icon bomb \
		-textvariable tkerror_priv
	widget_waitVariable tkerror_priv

	case $tkerror_priv in {
		OK {}
		terminate "
			puts stderr $info ; after 1 widget_checkAndDestroy .
		"
		abort {
			if {[info exists env(TKDUMP)]} {
				set dumpname $env(TKDUMP)
			} else {
				set dumpname tk-dump
			}
			set dumpfile [open $dumpname a]
			set errorInfo $info
			set errorCode $code
			debug_dump $dumpfile
			close $dumpfile
			puts stderr $info
			puts stderr "
Dump of Tk workspace is in file `$dumpname.'
"
			after 1 widget_checkAndDestroy .
		}
	}
	unset tkerror_priv
	modalDialog.end $w
	unset tkerror_active
}
