
#include "test.h"

extern void Objectify_init_test(Tcl_Interp* interp, ClientData d);

int
Tcl_AppInit(Tcl_Interp *interp)
{
    if (Tcl_Init(interp) != TCL_OK) return (TCL_ERROR);
    if (Tk_Init(interp) != TCL_OK) return (TCL_ERROR);
    
    Objectify_init_test(interp, (ClientData) Tk_MainWindow(interp));
    
    return (TCL_OK);
}

// --------------------------------

int
Foo::AfterConfigure(Tcl_Interp* interp)
{
    d = i - f;
    return (TCL_OK);
}

int
Foo::EchoCmd(Tcl_Interp* interp, int ac, char** av)
{
    for (int i = 0; i < ac; i++)
	Tcl_AppendElement(interp, av[i]);
    return (TCL_OK);
}

// --------------------------------

static void
DisplayBar(ClientData cl)
{
    Bar* b = (Bar *) cl;
    b->Draw();
}

int
Bar::AfterConfigure(Tcl_Interp* interp)
{
    Tk_SetBackgroundFromBorder(tkwin, bgBorder);
    
    Tk_GeometryRequest(tkwin, width, height);
    
    // Redraw this widget eventually.
    if (tkwin && Tk_IsMapped(tkwin) && !redraw_pending) {
	Tk_DoWhenIdle(DisplayBar, (ClientData) this);
	redraw_pending = 1;
    }
    
    return (TCL_OK);
}

void
Bar::Draw()
{
    Tk_Fill3DRectangle(Tk_Display(tkwin), Tk_WindowId(tkwin), bgBorder,
		       0, 0, width, height, borderwidth, relief);
    redraw_pending = 0;
}

// Here's the user defined junk.   ----------------

static int
frogsParse(ClientData cld, Tcl_Interp* interp, Tk_Window win,
	       char* value, char* record, int offset)
{
    Frogs* f = (Frogs *) (record + offset);
    return (Tcl_GetInt(interp, value, &f->f) != TCL_OK);
}

static char*
frogsPrint(ClientData cld, Tk_Window win, char* record, int offset,
	       Tcl_FreeProc **freep)
{
    static char buffer[128];
    Frogs* f = (Frogs *) (record + offset);
    sprintf(buffer, "%d", f->f);
    return (buffer);
}

// ----------------

static int
fruitcakePtrParse(ClientData cld, Tcl_Interp* interp, Tk_Window win,
	       char* value, char* record, int offset)
{
    Fruitcake** f = (Fruitcake**) (record + offset);
    return (Tcl_GetInt(interp, value, (int *) f) != TCL_OK);
}

static char*
fruitcakePtrPrint(ClientData cld, Tk_Window win, char* record, int offset,
	       Tcl_FreeProc **freep)
{
    static char buffer[128];
    Fruitcake** f = (Fruitcake* *) (record + offset);
    sprintf(buffer, "0x%x", (int) *f);
    return (buffer);
}

// ------------------

Tk_CustomOption Frogs_ConfigOption = { frogsParse, frogsPrint, NULL };
Tk_CustomOption FruitcakePtr_ConfigOption = { fruitcakePtrParse, fruitcakePtrPrint, NULL };
