# UserMaint V1.0 by Charles A. Eads
#
# Copyright (c) 1993 The Regents of the University of California.
# All rights reserved.
# 
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose, without fee, and without written agreement is
# hereby granted, provided that the above copyright notice and the following
# two paragraphs appear in all copies of this software.
# 
# IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
# DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
# OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
# CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
# 
# THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
# AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
# ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
# PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

proc control_menu_create {w} \
{
	global BACKGROUND_COLOR_MAIN
	frame $w.menu
	
	menubutton $w.menu.project -text "Project" -menu $w.menu.project.m
	menu $w.menu.project.m
	$w.menu.project.m add command -label "Apply Changes" -command "apply_init {$w}"
	$w.menu.project.m add command -label "Cancel" -command "control_cancel"
	
	menubutton $w.menu.edit -text "Edit" -menu $w.menu.edit.m
	menu $w.menu.edit.m
	$w.menu.edit.m add command -label "Up" -command "userlist_up {$w}"
	$w.menu.edit.m add command -label "Down" -command "userlist_down {$w}"
	$w.menu.edit.m add command -label "Move" -command "userlist_move {$w}"
	$w.menu.edit.m add command -label "Sort" -command "userlist_sort {$w}"
	
	menubutton $w.menu.usermaint -text "User Maint" -menu $w.menu.usermaint.m
	menu $w.menu.usermaint.m
	$w.menu.usermaint.m add command -label "Add" -command "add_create {$w}"
	$w.menu.usermaint.m add command -label "Edit" -command "edit_init {$w}"
	$w.menu.usermaint.m add command -label "Delete" -command "userlist_delete {$w}"
	
#	menubutton $w.menu.config -text "Config" -menu $w.menu.config.m
#	menu $w.menu.config.m
#	$w.menu.config.m add command -label "Speed Bar"
#	$w.menu.config.m add separator
#	$w.menu.config.m add command -label "Delete Item"
#	$w.menu.config.m add command -label "Add Item"
	
	label $w.menu.tail -relief flat
	
	
	menubutton $w.menu.help -text "Help" -menu $w.menu.help.m
	menu $w.menu.help.m
	$w.menu.help.m add command -label "UserMaint V1.0"
	$w.menu.help.m add command -label "Info" -command "control_display_info"

	pack append $w.menu \
		$w.menu.project {left} \
		$w.menu.edit {left} \
		$w.menu.usermaint {left} \
		$w.menu.tail {left expand fillx} \
		$w.menu.help {left}
#		$w.menu.config {left} \
}

proc control_panel_create {w} \
{
	global BACKGROUND_COLOR_MAIN
	frame $w.buttons -borderwidth 5 -background $BACKGROUND_COLOR_MAIN
	
	frame $w.buttons.left -relief raised
	button $w.buttons.left.add -text "Add" -command "add_create {$w}"
	button $w.buttons.left.edit -text "Edit" -command "edit_init {$w}"
	button $w.buttons.left.delete -text "Delete" -command "userlist_delete {$w}"
	button $w.buttons.left.apply -text "Apply Changes" -command "apply_init {$w}"
	pack append $w.buttons.left \
		$w.buttons.left.apply {bottom fillx} \
		$w.buttons.left.add {left expand fillx} \
		$w.buttons.left.edit {left expand fillx} \
		$w.buttons.left.delete {left expand fillx}
	
	frame $w.buttons.right -relief raised
	button $w.buttons.right.up -text "Up" -command "userlist_up {$w}"
	button $w.buttons.right.down -text "Down" -command "userlist_down {$w}"
	button $w.buttons.right.move -text "Move" -command "userlist_move {$w}"
	button $w.buttons.right.sort -text "Sort" -command "userlist_sort {$w}"
	button $w.buttons.right.cancel -text "Cancel" -command "control_cancel"
	pack append $w.buttons.right \
		$w.buttons.right.cancel {bottom fillx} \
		$w.buttons.right.up {left expand fillx} \
		$w.buttons.right.down {left expand fillx} \
		$w.buttons.right.move {left expand fillx} \
		$w.buttons.right.sort {left expand fillx}
	
	pack append $w.buttons \
		$w.buttons.left {left expand fill} \
		$w.buttons.right {right expand fill}
}

control_menu_create {}
#control_speedbar_create {}
userlist_create {}
if {$CONTROL_PANEL == {T}} \
{
	control_panel_create {}
	pack append . .menu {top expand fillx} .userlist {top expand fillx} .buttons {bottom expand fillx}
} else \
{
	pack append . .menu {top expand fillx} .userlist {top expand fillx}
}

userlist_update {} $passwd_text $group_text

bind .userlist.list <Double-Button-1> {edit_init {}}

proc control_cancel {} \
{
	passwd_global_unlock
	passwd_unlock
	exit
}

proc control_display_info {} \
{
	global BACKGROUND_COLOR_MAIN
	catch \
{
	toplevel .info -class Dialog -border 0
	wm title .info "UserMaint V1.0 by Charles A. Eads"
	frame .info.info -borderwidth 5 -background $BACKGROUND_COLOR_MAIN
	message .info.info.msg -font *times-bold-*-*-*-*-140-*-*-*-*-*-* -relief raised -aspect 250 \
-text "\
                          UserMaint V 1.0 by Charles A. Eads

Copyright (c) 1993 The Regents of the University of California.
                                          All rights reserved.

UserMaint is a user account maintenace package written in TCL/TK.  \
It provides a generic and highly modifiable graphical interface between the \
System Administrator and the /etc/passwd and /etc/group files.  Refer to the \
manual page for further details."
	frame .info.control -borderwidth 5 -background $BACKGROUND_COLOR_MAIN
	button .info.control.ok -text "OK" -command {destroy .info}
	pack append .info.info .info.info.msg {top}
	pack append .info.control .info.control.ok {top expand fillx}
	pack append .info .info.info {top expand fillx} .info.control {bottom expand fillx}
}
}
