#
# look for a Profile value in various places
# 1	- in the environment under the name envname
# 2	- in the news/lib directory (in a file named by libname)
# else	- defaultval
#

proc _printAndReturnItem {i v} { 
    puts stderr "Profile: '$i'	'$v'"; 
    return $v 
};
proc _returnItem {i v} { 
    return $v 
};
set _p _printAndReturnItem

proc setProfile {item envname libname defaultval} {
    global _p Profile env
    # first check env
    if {[info exists env($envname)]} {
	return [$_p $item [set Profile($item) $env($envname)]]
    }
    # next check news lib
    if {[info exists Profile(NewsDir)]} {
	if {$libname!="" && [file readable $Profile(NewsDir)/lib/$libname]} {
	    set fin [open $Profile(NewsDir)/lib/$libname]
	    set libval [read $fin]
	    close $fin
	    return [$_p $item \
		[set Profile($item) [string trim $libval " \t\n\r"]]]
	}
    }
    # use supplied defaultname
    return [$_p $item [set Profile($item) $defaultval]]
}

proc initProfile {{printit 0}} {
    global _p Profile
    if {$printit} { set _p  _printAndReturnItem } else { set _p  _returnItem }
    if {[file readable [glob ~/.artclsProfile]]} {
	source [glob ~/.artclsProfile]
    } else {
	source $Profile(ArtclsLib)/defaultProfile.t
    }
}
