##
## tiumer.t - timer functions
##

# proc timerstart {{timername} {procname} {interval 10000}}
#
# start a timer with name 'timername' which will run proc every 'interval'
# microseconds
#
proc timerstart {{timername} {procname} {interval 10000}} {
    if { $interval } {
	global IntervalFor__$timername
	if { [info exists IntervalFor__$timername] } {
	    error [format "timerstart: timer %s already exists" $timername]
	}
	set IntervalFor__$timername $interval
	after $interval timerstart $timername $procname 0
    } else {
	global IntervalFor__$timername
	if {[info exists IntervalFor__$timername]} {
	    $procname $timername
	    after [set IntervalFor__$timername] \
		  timerstart $timername $procname 0
	}
    }
}

# proc timerstop {timername}
#
# stop a timer with name 'timername' that was started by the timerstart
# tcl proc
#
proc timerstop {timername} {
    global IntervalFor__$timername
    if { [info exists IntervalFor__$timername] } {
	unset IntervalFor__$timername
    }
}

