# Copyright (c) 1993 by Sanjay Ghemawat
##############################################################################
# ItemListing
#
# Description
# ===========
# Show item listing.

# For autoloading.
proc ItemListing {} {}

class ItemListing {} {
    set slot(nexttag) 1

    toplevel .$self -bd 0 -class Listing -geometry ""
    set g [option get .$self geometry Geometry]
    if {$g != ""} {
	wm geometry .$self $g
    }

    focus_interest .$self
    bind .$self <Any-Enter> [list focus_restrict .$self]

    wm title .$self "Calendar Items"
    wm iconname .$self "Items"
    wm protocol .$self WM_DELETE_WINDOW [list class_kill $self]

    # Done button
    frame .$self.bot -relief raised -bd 1
    frame .$self.bot.default -relief sunken -bd 1
    button .$self.bot.default.b -text Okay -command [list class_kill $self]
    pack append .$self.bot.default .$self.bot.default.b {right padx 3m pady 3m}
    pack append .$self.bot .$self.bot.default {right padx 3m pady 3m}

    # Display
    scrollbar .$self.scroll -relief raised -bd 1 -orient vertical\
	-command [list .$self.display yview]
    text .$self.display\
	-setgrid 1\
	-relief raised\
	-bd 1\
	-yscroll [list .$self.scroll set]\
	-width 50\
	-height 20\
	-wrap none

    # Pack it all up
    pack append .$self .$self.bot {bottom fillx}
    pack append .$self .$self.scroll {right filly}
    pack append .$self .$self.display {left expand fill}

    # Key bindings
    bind .$self <Control-c> [list class_kill $self]
    bind .$self <Return> [list class_kill $self]
    bind .$self.display <Double-1> [list $self null]
    bind .$self.display <Triple-1> [list $self null]

    # Tag displays
    .$self.display tag configure -date -font [pref smallHeadingFont]

    # Disallow edits
    .$self.display configure -state disabled
}

method ItemListing cleanup {} {
    focus_disinterest .$self
    focus_unrestrict .$self
    destroy .$self
}

# effects - do nothing
method ItemListing null {} {
}

# effects - Fill listing with items in specified date range.
method ItemListing dayrange {start finish} {
    # Allow edits temporarily
    .$self.display configure -state normal

    set sep  ""
    set date ""
    cal listing $start $finish i d {
	if {$date != $d} {
	    # New date
	    set date $d
	    $self insert {-date} "$sep[date2text $date]\n"
	    set sep "\n"
	}

	$self insert {-item} [item2text $i]
    }

    # No more editing
    .$self.display configure -state disabled
}

# effects - Fill listing with items in specified calendar
method ItemListing calendar {calendar} {
    # Allow edits temporarily
    .$self.display configure -state normal

    cal incalendar $calendar i {
	if [catch {set date [$i first]}] {
	    continue
	}

	set tag tag.$slot(nexttag)
	incr slot(nexttag)

	# Print date description
	set type [$i type]
	if {$type == ""} {
	    set str [date2text $date]
	} else {
	    set str $type
	}
	$self insert [list -date $tag] "$str\n"

	$self insert [list $tag] "[item2text $i]\n"

	.$self.display tag bind $tag <Double-Button-1> [list $self view $date]
    }

    # No more editing
    .$self.display configure -state disabled
}

# effects - Generate DayView for specified date.
method ItemListing view {date} {
    [DayView] set_date $date
}

# effects - Insert string with specified tags.
method ItemListing insert {tags str} {
    set start [.$self.display index insert]
    .$self.display insert insert $str

    # Remove existing tags
    foreach t [.$self.display tag names $start] {
	.$self.display tag remove $t $start insert
    }

    # Add new tags
    foreach t $tags {
	.$self.display tag add $t $start insert
    }
}
