# Copyright (c) 1993 by Sanjay Ghemawat
###############################################################################
# List generation support.

# effects - Return unparsing of date.
proc date2text {date} {
    global weekday_name month_name

    set split [date split $date]
    return [format "%s %s %d, %d"\
	    $weekday_name([lindex $split 1])\
	    $month_name([lindex $split 2])\
	    [lindex $split 0]\
	    [lindex $split 3]]
}

# effects - Return unparsing of time.
#	    Time is number of minutes since midnight.
proc time2text {time} {
    set min [expr $time%60]
    set hour [expr $time/60]
    set mer  am
    if {$hour >= 12} {
	set mer pm
	incr hour -12
    }
    if {$hour == 0} {set hour 12}

    return [format "%d:%02d%s" $hour $min $mer]
}

# effects - Return unparsing for item.
proc item2text {item} {
    set header " * "
    if [$item is appt] {
	set start [time2text [$item starttime]]
	set finish [time2text [expr [$item starttime]+[$item length]]]
	set header "$header$start to $finish\n   "
    }
    
    set str [$item text]
    
    # Strip trailing whitespace
    regsub -all "\[ \t\n\]\+\$" $str "" str
    
    # Indent string
    regsub -all "\n" $str "\n   " str

    return "$header$str\n"
}
