.\" Copyright (c) 1993 by Sanjay Ghemawat
.TH ICAL 1 "July 27, 1993"
.SH NAME
ical \- X based calendar program

.PP
.SH DESCRIPTION

\fIIcal\fP provides an X interface for maintaining a calendar.  A
calendar is basically just a set of items. An item is either an
appointment, or a notice. An appointment starts at a particular time of
the day, and finishes at a particular time of the day. A notice does not
have any starting or ending time. Notices are useful for marking certain
days as special. For example, a calendar may contain a notice for April
15th indicating that taxes are due.  When the documentation below refers
to an \fIitem\fP, it applies both to notices and appointments.

The main features of \fIical\fP are:

.Ds
    * Items can be created edited and deleted easily.
    * Items can be cut, copied and pasted.
    * Items can be made to repeat in various ways.
    * \fIIcal\fP will post reminders for upcoming appointments.
    * \fIIcal\fP can print and list item occurrences.
    * An \fIical\fP calendar can include other calendars.
    * \fIIcal\fP calendars can be shared by different users.
.De

.SH GENERAL OPTIONS

You can specify various command line options to control ical.  The
following general options can be used even when you are not logged in
on an X display.
.TP
-calendar \fIfile-name\fP
The calendar is read from the specified file.  See the section
"CALENDAR FILE" for more information.
.TP
-list
Print a listing of today's items and exit immediately.  See the section
"LISTING ITEMS" for details on the actual items printed by this option.
.TP
-show +\fIdays\fP
Print a listing for items in the range
[\fItoday\fP..\fItoday\fP+\fIdays\fP-1] and exits immediately.  See
the section "LISTING ITEMS" for details on the actual items printed by
this option.

.SH X OPTIONS

The following options are valid only if you are logged in on an X
display.

.TP
-iconic
Start up with the main window iconified.
.TP
-popup
Popup a window containing a listing of today's items and exit as soon
as the window is dismissed.  See the section "LISTING ITEMS" for
details on the actual items printed by this option.
.TP
-mono
Do not use colors even if the display supports them.
.TP
-geometry \fIgeometry\fP
Use \fIgeometry\fP as the geometry for the main window.
.TP
-display \fIdisplay\fP
Run ical on the specified X display.

.SH CALENDAR FILE

A calendar is stored in a calendar file. The default calendar file is
named ".calendar" and is kept in the user's home directory. If the
"CALENDAR" environment variable is set, its value is used as the
name of the calendar file. The "CALENDAR" environment variable and
the default can both be overridden by specifying a file name on the
command line - "ical -calendar \fIfile-name\fP".

\fIIcal\fP periodically saves any modifications made to a calendar to
the corresponding calendar file. Changes can be explicitly saved to the
calendar file by selecting the \fISave\fP entry from the
\fICalendar\fP menu.

You can discard any un-saved changes made to the calendar by selecting
the \fIRe-Read\fP entry from the \fICalendar\fP menu. The
\fIRe-Read\fP entry is also useful for incorporating changes made to a
shared calendar by other users.

The \fIExit\fP entry in the \fICalendar\fP menu saves any changes and
then kills the calendar program.

.SH WINDOWS

The main calendar window displays the appointments and notices for a
particular date.  The top left portion of the window contains a date
selector. You can click on the various arrows to change the month or
the year.  The day of the month can be selected by clicking on the
appropriate day in the month display.  The date selector contains
various other buttons for convenient date selection.

The bottom left portion of the window contains the notices for the
selected date. You can scroll this region by using the scroll bar.

The right portion of the window contains the appointments for the
selected day. You can scroll this region by using the scroll bar, or by
dragging with the middle mouse button in the background.

A menubar runs along the top of the calendar window.  The \fICalendar\fP
menu allows you to create and destroy application windows.

.TP
.B New Window
Opens a new calendar window. This new window can be
used to view the items for a different date than the
original window.
.TP
.B Close Window
Closes the selected window.
.PP
The bottom portion of the window contains a status line. This status
line indicates the calendar from which the selected item comes and
whether or not the selected item repeats.

.SH NOTICES

You can enter notices by clicking in the background in the bottom-left
portion of the main calendar window. This click will create a new
notice for the selected date.  You can enter text into the notice by
typing into it while it is selected (selected notices are highlighted
by being displayed in different colors).  A notice can be selected for
editing by clicking with left button. You can change the length
allocated to a notice by dragging with the right mouse button held
down.

.SH APPOINTMENTS

You can enter appointments by left-clicking in the background in the
right portion of the main calendar window. This click will create a new
appointment for the selected date. The start time for this appointment
is determined by the click location. You can move the appointment by
dragging it with the middle mouse button held down. The appointment can
be resized by dragging with the right mouse button held down.
Appointment text can be edited by typing into the appointment window
while it is selected.

\fIIcal\fP generates reminders for appointments. By default, the first
reminder is generated fifteen minutes before the appointment is
supposed to start and successive reminders are generated every five
minutes until the appointment actually starts.  You can change the
timings of these reminders with the \fIChange Alarms\fP entry in the
\fIEdit\fP menu.

.SH REPEATING ITEMS

Items can be made to repeat in various ways. Item repetition can be
controlled by using the entries in the \fIRepeat\fP menu.  These
entries make the item repeat in certain frequently used ways. For
example, the \fIMonthly\fP entry makes the selected item repeat once
per month.

In addition to making an item repeat in one of the pre-defined ways,
you can also restrict an item's starting and finishing date by
selecting the \fIMake First Date\fP or the \fIMake Last Date\fP
entry from the \fIRepeat\fP menu.

Normally, a modication to a repeating item applies to all occurrences of
that item. A single occurrence of a repeating item can be modified by
selecting the occurrence and then choosing the \fIMake Unique\fP entry
from the \fIEdit\fP menu.  The selected occurrence can now be modified
independently of the repeating item.

.SH CLIPBOARD

The application has a clipboard that can store a single item. The
\fICopy\fP entry in the \fIEdit\fP menu copies the selected item into
the clipboard.  The \fICut\fP entry does the same, but it also deletes
the item from the calendar. If the selected item repeats, then the
\fICut\fP command allows the user to delete all occurrences of the
item, or just the selected occurrence.  However, if the selected
item does not belong to you, then \fICut\fP just hides the item
from you.  Other people will still see the item.

An item in the clipboard can be inserted into the current day by
selecting \fIPaste\fP from the \fIEdit\fP menu. The newly pasted item
loses all repetition information, and occurs just on the day in which
it was pasted.

.SH LISTING ITEMS

You can generate listings of imminent items by selecting one of the
options in the \fIList\fP menu.  You can also use the command line
options \fI-list\fP, \fI-show\fP, or \fI-popup\fP to generate item
listings.  The command line options are most useful in ".login" files.

An item is included in a listing for a particular date if it occurs
either on that date, or on the very next day. Sometimes, you want to
include an item in listings for earlier dates. For example, if you
have an item reminding you of a birthday on March 17th, you might want
this item to be included in all listings from March 7th to March 17th
so that you will have enough time to go out and buy a present.  You
can achieve this effect by selecting the \fITen Days Early\fP entry
from the \fIEarly-Warning\fP menu.

The \fIA Day Early\fP entry restores the default behavior. The \fIOn
Occurence\fP entry marks the item so that it is only included in the
listing for a particular date if it occurs on that date.

.SH PRINTING

All items in a given range can be printed to a postscript printer by
selecting one of the entries in the \fIPrint\fP menu. The \fIMonth\fP
entry prints all items for the current month on a single sheet of paper.
The other menu entries print all items that occur on the currently
selected date, or within the next \fIn - 1\fP days. For example, if the
selected date is April 17, then the \fIEight Days\fP entry can be used
to print all items in the range April 17 to April 24.

The postscript code for printing the items is fed to a user-specified
filter. The default filter is \fIlpr\fP.

.SH INCLUDING CALENDARS

You can include other calendars into your private calendar. This
facility is mainly useful for allowing a group of people to share a
common set of items. For example, members of a particular group might
have a calendar that contains the birthdays for each member of the
group. This calendar can be included in each group member's private
calendar.

You can include a calendar by selecting the \fIInclude Calendar\fP
entry from the \fICalendar\fP menu. You can remove an included
calendar by selecting the \fIRemove Calendar\fP entry from the
\fICalendar\fP menu.

An item can be moved between calendars by selecting the \fIMove Item
To ...\fP entry from the \fIEdit\fP menu.

You can list all items in a particular calendar by selecting the
\fIFrom Calendar ...\fP entry from the \fIList\fP menu.

.SH CUSTOMIZATION

Limited portions of \fIical\fP can be customized via the
\fICustomize\fP entry in the \fICalendar\fP menu.

.IP Display\ Am/Pm
If this option selected, time will be printed in twelve hour mode
with "am" or "pm" indicators.  Otherwise, time will be printed
in twentyfour hour mode.

.IP Monday\ Starts\ Week
If this option is selected, month displays will start each week off
on a Monday.  Otherwise, each week will start on a Sunday.

.PP
You can specify several X resources to customize the rest of the
appearance and behavior of \fIical\fP.

.SS BEHAVIOR
.IP Ical.pollSeconds
Calendar files are saved, and changes made by
other people are incorporated once every \fIpollSeconds\fP seconds.
The default value is 30.  If ical appears sluggish, or if it is using
too much CPU time, increase this value.

.IP Ical.alarms
List of minutes before an appointment that alarms should go off.  The
default is \fIalarms: 0 5 10 15\fP. This default means that alarms go
off when the appointment starts, and also 5, 10, and 15 minutes before
the appointment starts.  You can override this default on an
appointment-by-appointment basis by selecting the \fIChange Alarms\fP
entry from the \fIEdit\fP menu.

.SS DIMENSIONS
.IP Ical.apptStartTime
The time that initially appears at the top of the appointment
listing.  The format for the time specification is
\fIhh:mm\fP. The default value for this resource is
\fI8:00\fP.

.IP Ical.apptLines
The number of lines that appear in the appointment listing. The default
is 20. Each line represents 30 minutes and therefore by default the
appointment listing is high enough to display ten hours at a time.

.IP Ical.noteLines
The height of the notice window in lines. The default is 8.

.IP Ical.itemWidth
The width of item windows.  The width is specified as a floating point
number followed by an optional unit specification.  If the unit
specification is left off, then the units default to screen pixels.
Legal unit specifications are \fIc\fP for centimeters, \fIi\fP for inches,
\fIm\fP for millimeters, and \fIp\fP for printer points.  The default
item window width is 3.5i (three and a half inches).

.IP Ical.Dayview.geometry
X geometry specification for main calendar window.  Usually, you will
just specify the window position here.  The size of the window is
easier to specify via \fIIcal.apptLines\fP, \fIIcal.noteLines\fP, and
\fIIcal.itemWidth\fP.

.IP Ical.Reminder.geometry
X geometry specification for item reminders.  Usually, you will
just specify the window position here.  The window size will be
calculated automatically.

.IP Ical.Listing.geometry
X geometry specification for item listings.  Usually, you will
just specify the window position here.  The window size will be
calculated automatically.

.IP Ical.vertical
If this boolean option has the value "1", then the various components
of the ical window will be laid out vertically as opposed to the
default layout where the appointments are laid out on the right side
of the window.  The default value for this option is "0".

.SS COLORS
If ical windows show up with illegible colors (not enough distinction
between background and foreground), it may be because your X resources
contain definitions for "*foreground" or "*background" that conflict
with ical colors.  In general, it is a bad idea to define
"*foreground" and "*background" in your resources because it will
break a number of programs.  You will be better off defining resources
on an application by application basis.

.\".RS
.IP Ical*foreground
.ns
.IP Ical*background
Set the colors used for most of the \fIical\fP windows.
.\".RS

.\".RS
.IP Ical.itemFg
.ns
.IP Ical.itemBg
The foreground and background colors for unselected items.  The default
foreground is black and the default background is gray.

.IP Ical.itemSelectFg
.ns
.IP Ical.itemSelectBg
The foreground and background colors for selected items.  The default
foreground is yellow and the default background is blue.

.IP Ical.apptLineColor
The color for the background lines and times displayed in the
appointment window.

.IP Ical.weekdayColor
The color used to display days of the week.  The default is black.

.IP Ical.weekendColor
The color used to display weekends.  The default is red.

.IP Ical.interestColor
The color used to highlight interesting dates.  The default is blue.

.SS FONTS
.IP Ical.fontFamily
Preferred font family.  Fonts for various purposes are obtained from
this family unless overridden with one of the specifications below.
The default font family is "times".  Some other font families you can
specify here are "charter", "new century schoolbook", and "helvetica".

.IP Ical.itemFont
Font used to display item contents.

.IP Ical.weekdayFont
Font used for displaying days of the week.

.IP Ical.weekendFont
Font used for displaying weekends.

.IP Ical.interestFont
Font used to highlight interesting dates.

.IP Ical.smallHeadingFont
Font used for small headings.

.IP Ical.largeHeadingFont
Font used for large headings.

.IP Ical*\fI<class>\fP*font:
Font used for windows of a certain class.  Possible values for
\fI<class>\fP are "Dialog", "Button", "Label", "Menubutton", "Menu",
"Listbox", and "Reminder".

.SH AUTHOR

Sanjay Ghemawat (sanjay@lcs.mit.edu)

.SH COPYRIGHT

Copyright (c) 1993 by Sanjay Ghemawat.

Permission is granted to make and distribute verbatim copies of this
manual provided the copyright notice and this permission notice are
preserved on all copies.
