/* Copyright (c) 1993 by Sanjay Ghemawat */
#ifndef _MISC_TCL_H
#define _MISC_TCL_H

/*
 * Miscellaneous TCL support.
 */

extern "C" {
#include <tcl.h>
}

#define TCL_Return(tcl,str) do { Tcl_SetResult(tcl, (str), TCL_STATIC); return TCL_OK; } while (0)

#define TCL_Error(tcl,str) do {Tcl_SetResult(tcl, (str), TCL_STATIC); return TCL_ERROR; } while (0)

/*
 * Backward compatibility for versions before Tcl 7.0.
 */
#if (TCL_MAJOR_VERSION < 7)

extern "C" {
#include <tclHash.h>
}

#define TCL_EVAL(interp,body) Tcl_Eval(interp, body, 0, 0)

#else

#define TCL_EVAL(interp,body) Tcl_Eval(interp, body)

#endif

#endif /* _MISC_TCL_H */
