# .textbindings.tcl - emacs-like keyboard bindings for the edit.tk application
#    (and any other Tk-based applications that choose to honour this file)

# Note: many applications may redefine some of these keys.

# TO DO:
# ^V, M-V, make deletion commands save text like emacs, ^Y, maybe implement
#   arguments, at least numeric ones.  (^U)
# ^G ( in the apps should be bound to Cancel! )
# ^L
# sentence-manipulation stuff
# case change commands, transposition commands
# ^Q - quoted insert
# commands to do with mark?

######################################################################
# j:selection_if_any - return selection if it exists, else {}
#   this is from kjx@comp.vuw.ac.nz (R. James Noble)
#   defined elsewhere, but copied here for portability
######################################################################

proc j:selection_if_any {} {
  if {[catch {selection get} s]} {return ""} {return $s}
}

### minimal Entry bindings ###

bind Entry <Control-slash> {%W insert insert "\\"}
bind Entry <Control-quoteright> {%W insert insert "`"}
bind Entry <Control-semicolon> {%W insert insert "|"}
bind Entry <Control-a> {%W icursor 0}
bind Entry <Control-e> {%W icursor end}
bind Entry <Left> {%W icursor [expr {[%W index insert] - 1}]}
bind Entry <Right> {%W icursor [expr {[%W index insert] + 1}]}
bind Entry <Control-b> {%W icursor [expr {[%W index insert] - 1}]}
bind Entry <Control-f> {%W icursor [expr {[%W index insert] + 1}]}
bind Entry <2> {%W insert insert [j:selection_if_any]}
bind Entry <Control-w> {catch {%W delete sel.first sel.last}}
bind Entry <Control-d> {%W delete insert end}
bind Entry <Control-q> {}
bind Entry <Control-q><KeyPress> {%W insert insert %A}
### jayisms - useful on a NeXT ###

bind Text <Control-slash> {%W insert insert "\\"}
bind Text <Control-quoteright> {%W insert insert "`"}
bind Text <Control-semicolon> {%W insert insert "|"}
bind Text <3> {%W insert insert [j:selection_if_any]}
bind Entry <Control-slash> {%W insert insert "\\"}
bind Entry <Control-quoteright> {%W insert insert "`"}
bind Entry <Control-semicolon> {%W insert insert "|"}
bind Entry <3> {%W insert insert [j:selection_if_any]}

### cursor movement: ###

bind Text <Control-a> {%W mark set insert {insert linestart}}
bind Text <Control-e> {%W mark set insert {insert lineend}}
# cursor keys
bind Text <Up> {
  %W mark set insert {insert - 1 line}
  %W yview -pickplace insert
}
bind Text <Down> {
  %W mark set insert {insert + 1 line}
  %W yview -pickplace insert
}
bind Text <Left> {
  %W mark set insert {insert - 1 char}
  %W yview -pickplace insert
}
bind Text <Right> {
  %W mark set insert {insert + 1 char}
  %W yview -pickplace insert
}
#
# emacs cursor movement
bind Text <Control-p> {
  %W mark set insert {insert - 1 line}
  %W yview -pickplace insert
}
bind Text <Control-n> {
  %W mark set insert {insert + 1 line}
  %W yview -pickplace insert
}
bind Text <Control-b> {
  %W mark set insert {insert - 1 char}
  %W yview -pickplace insert
}
bind Text <Control-f> {
  %W mark set insert {insert + 1 char}
  %W yview -pickplace insert
}
#
bind Text <Escape><b> { ;# back up by one word
  while {[%W compare insert != 1.0] &&
         [%W get {insert - 1 char}] == " "} {
    %W mark set insert {insert - 1 char}
  }
  while {[%W compare insert != 1.0] &&
         [%W get {insert - 1 char}] != " "} {
    %W mark set insert {insert - 1 char}
  }
}
bind Text <Escape><f> { ;# advance by one word
  while {[%W compare insert != end] &&
         [%W get insert] == " "} {
    %W mark set insert {insert + 1 char}
  }
  while {[%W compare insert != end] &&
         [%W get insert] != " "} {
    %W mark set insert {insert + 1 char}
  }
}
#
bind Text <Escape><less> { ;# beginning of file
  %W mark set insert 0.0
  %W yview -pickplace 0.0
}
bind Text <Escape><greater> { ;# end of file
  %W mark set insert end
  %W yview -pickplace end
}
#
# have to do the following when a modifier might need to be pressed:
bind Text <Escape><Shift_L><less> [bind Text <Key-Escape><Key-less>]
bind Text <Escape><Shift_R><less> [bind Text <Key-Escape><Key-less>]
bind Text <Escape><Shift_L><greater> [bind Text <Key-Escape><Key-greater>]
bind Text <Escape><Shift_R><greater> [bind Text <Key-Escape><Key-greater>]

### deletion: ###
#
# currently EMACSBUFFER and ^Y only work with ^K and ^W, and only
# restore a single deletion with ^W, or contiguous deletions with ^K.
# this should be fixed.

bind Text <Control-k> {
  global EMACSBUFFER
  if {[%W index insert] == [%W index {insert lineend}]} then {
    set EMACSBUFFER [%W get insert]
    %W delete insert
  } else {
    set EMACSBUFFER [%W get insert {insert lineend}]
    %W delete insert {insert lineend}
  }
}
bind Text <Control-k><Control-k> {
  global EMACSBUFFER
  if {[%W index insert] == [%W index {insert lineend}]} then {
    append EMACSBUFFER [%W get insert]
    %W delete insert
  } else {
    append EMACSBUFFER [%W get insert {insert lineend}]
    %W delete insert {insert lineend}
  }
}
bind Text <Control-w> {
    catch {
    set EMACSBUFFER [%W get sel.first sel.last]
    %W delete sel.first sel.last
  }
}
bind Text <Control-y> {
  %W insert insert $EMACSBUFFER
}
bind Text <Control-d> {%W delete insert}
bind Text <Escape><Delete> {
  while {[%W compare insert != 1.0] &&
         [regexp "\[ \n\t-\]" [%W get {insert - 1 char}]]} {
    %W delete {insert - 1 char}
  }
  while {[%W compare insert != 1.0] &&
         (! [regexp "\[ \n\t-\]" [%W get {insert - 1 char}]])} {
    %W delete {insert - 1 char}
  }
}
bind Text <Escape><d> {
  while {[%W compare insert != end] &&
         [regexp "\[ \n\t-\]" [%W get insert]]} {
    %W delete insert
  }
  while {[%W compare insert != end] &&
         (! [regexp "\[ \n\t-\]" [%W get insert]])} {
    %W delete insert
  }
}

### x mouse paste ###
bind Text <2> {
  %W insert insert [j:selection_if_any]
}
