# .edittkrc.tcl - user customisation file for edit.tk
######################################################################

global TEXTWIDGET; set TEXTWIDGET .main.t
#.main.t tag configure roman -font *-helvetica-medium-r-normal--*-100-*
.main.t configure -font *-helvetica-medium-r-normal--*-100-*
.main.t tag configure italic -font *-helvetica-medium-o-normal--*-100-*
.main.t tag configure bold -font *-helvetica-bold-r-normal--*-100-*
.main.t tag configure boldital -font *-helvetica-bold-o-normal--*-100-*
.main.t tag configure typewriter -font *-courier-medium-r-normal--*-100-*
.main.t tag configure headline -font *-helvetica-bold-o-normal--*-120-*

proc tagsel {{tag {}}} {
  set first [.main.t index sel.first]
  set last [.main.t index sel.last]
  set alltags [.main.t tag names]

  foreach oldtag $alltags {
    .main.t tag remove $oldtag $first $last
  }

  if {$tag != {}} {
    .main.t tag add $tag $first $last
  }
}

proc writerange {{font rm} {string ""} {file stdout}} {
  regsub -all {[]\\"$[\}\{]} $string {\\&} string
  puts $file [format {%s "%s"} $font $string]
}

proc fontify {} {
  global FILENAME		;# so it can be default
  append FILENAME {}		;# make sure it's defined

  set prompt_result [j:fs {} "Save as:"]
  if {$prompt_result != {././/CANCEL//./.} && \
     ( ! [file exists $prompt_result] || \
      [j:confirm "File \"$prompt_result\" exists; replace it?"] )} then {
    set FILENAME $prompt_result
  } else {
    return 1
  }
  set file [open $FILENAME w]
  
  for {.main.t mark set marker 1.0} {[.main.t compare marker < end]} {} {
    set char [.main.t get marker]
    case [.main.t tag names marker] in {
    {italic} {
      set range \
        [.main.t tag nextrange italic marker {marker+40chars wordend}]
      set string [.main.t get [lindex $range 0] [lindex $range 1]]
      writerange it $string $file
      .main.t mark set marker [lindex $range 1]
    }
    {boldital} {
      set range \
        [.main.t tag nextrange boldital marker {marker+40chars wordend}]
      set string [.main.t get [lindex $range 0] [lindex $range 1]]
      writerange bi $string $file
      .main.t mark set marker [lindex $range 1]
    }
    {bold} {
      set range \
        [.main.t tag nextrange bold marker {marker+40chars wordend}]
      set string [.main.t get [lindex $range 0] [lindex $range 1]]
      writerange bf $string $file
      .main.t mark set marker [lindex $range 1]
    }
    {typewriter} {
      set range \
        [.main.t tag nextrange typewriter marker {marker+40chars wordend}]
      set string [.main.t get [lindex $range 0] [lindex $range 1]]
      writerange tt $string $file
      .main.t mark set marker [lindex $range 1]
    }
    {headline} {
      set range \
        [.main.t tag nextrange headline marker {marker+40chars wordend}]
      set string [.main.t get [lindex $range 0] [lindex $range 1]]
      writerange hl $string $file
      .main.t mark set marker [lindex $range 1]
    }
    default {
      for {.main.t mark set start marker} \
          {[.main.t compare marker < end] &&
           [.main.t compare marker < {start+40chars wordend}] &&
           ([llength [.main.t tag names marker]] == 0)} \
          {.main.t mark set marker "marker + 1 char"} {
        # empty body; work is done by test and increment
      }
      set string [.main.t get start marker]
      writerange rm $string $file
    }
    }
  }
  close $file
}

######################################################################
# redefine tke_label

set oldbody [info body tke_set_label]
proc tke_set_label {{title USE_FILENAME} {l .main.l}} "
  $oldbody
  wm title . \[file tail \$title\]
"

######################################################################
# additional Emacs-style keyboard bindings, supplementing the ones in
# .textbindings.tcl.  These have to be here because they are
# application-specific; they refer to procedures defined in edit.tk.

# do-nothing bindings:
bind Text <Control-x> {%W mark set insert insert}
bind Text <Control-u> {%W mark set insert insert} ;# naah!
bind Text <Escape> {%W mark set insert insert}
#
bind Text <Control-x><Control-s> {cmd_save}
bind Text <Control-x><Control-w> {cmd_saveas}
bind Text <Control-x><Control-f> {cmd_load}
bind Text <Control-x><Control-v> {cmd_load}
bind Text <Control-x><Control-c> {cmd_quit}
bind Text <Control-s> {cmd_find}
bind Text <Control-percent> {cmd_find}
bind Text <Control-u><Control-k> { ;# too simplistic - just an example.
  %W delete insert {insert lineend}
  %W delete insert
  %W delete insert {insert lineend}
  %W delete insert
  %W delete insert {insert lineend}
  %W delete insert
  %W delete insert {insert lineend}
  %W delete insert
}

######################################################################
# define the User menu:

if [winfo exists .menu.help] {
  destroy .menu.help
}

menubutton .menu.help -text {Help} -menu .menu.help.m

menu .menu.help.m
.menu.help.m add command -label {Roman} -command {tagsel {}}
.menu.help.m add command -label {Italic} -command {tagsel italic}
.menu.help.m add command -label {Bold} -command {tagsel bold}
.menu.help.m add command -label {Bold Italic} -command {tagsel boldital}
.menu.help.m add command -label {Typewriter} -command {tagsel typewriter}
.menu.help.m add command -label {Headline} -command {tagsel headline}
.menu.help.m add separator
.menu.help.m add command -label {Write Out . . .} -command {
  fontify
}
.menu.help.m add command -label {Read In . . .} -command {
  global FILENAME; append FILENAME {}
  set prompt_result [j:fs {} "Load:"]
  if {$prompt_result != {././/CANCEL//./.}} then {
    set FILENAME $prompt_result
    source $FILENAME
  }
  focus .main.t
}

pack append .menu .menu.help left

######################################################################
# change appearance of selected text:

set TEXTSB grey66
set TEXTSF black

######################################################################
# window icon:

global env
wm iconbitmap . "@$env(HOME)/xbm/xtypewriter.xbm"
