# ~/.tk/jbrowserrc - initialisation file for jbrowser
# sets default actions for file types, and adds a User menu
######################################################################

proc jbr:userhook {} {
  menubutton .menu.user -text User -menu .menu.user.m
  menu .menu.user.m
  .menu.user.m add command -label {New xterm} -command {exec xterm &}
  .menu.user.m add command -label {New jedit} -command {exec jedit &}
  .menu.user.m add separator
  .menu.user.m add command -label {Go to Selection} -command {
    cd [selection get]
    jbr:fill_browser
  }
  
  tk_menuBar .menu .menu.browser .menu.file .menu.user
  
  pack append .menu .menu.user right
  
  .cur.list configure \
    -selectborderwidth 1 \
    -selectforeground black
}

######################################################################
# jbr:cmd:view - view contents of a file
######################################################################

proc jbr:cmd:view {} {
  foreach i [getfiles] {
    if {![file isdirectory $i]} {
      case $i in {

      {browser-test}
	{j:alert -text {Yup, you're using your own ticklish script.}}
      {*.dvi}
        {exec xdvi $i &}
      {*.obj}
	{exec tgif $i &}
      {*.ps *.eps}
        {exec ghostview $i &}
      {*.gif *.jpg *.p?m *.xbm}
	{exec xv -perfect $i &}
      {*.tiff}
        {exec xtiff $i &}
      {*.rgb}
        {exec ipaste $i &}
      {*.tar.Z}
	{jbr:more {Uncompressed archive contents} \
	[exec zcat $i | tar tBvf -]}
      {*.Z}
	{jbr:more {Uncompressed file} [exec zcat $i]}
      {*.tar}
	{jbr:more {Archive contents} [exec tar tvf $i]}
      {default}
	{jbr:more "Contents of `$i'" [exec cat $i]}

      }
    } else {
      j:alert -text "`$i' is a directory."
    }
  }
}

######################################################################
# jbr:cmd:edit - edit a file
######################################################################

proc jbr:cmd:edit {} {
  foreach i [getfiles] {
    if {![file isdirectory $i]} {
      case $i in {

      {browser-test}
	{j:alert -text {Yup, you're using your own ticklish script.}}
      {*.xbm}
		{exec bitmap $i &}
      {*.bdf}
		{exec xfed $i &}
      {*.dvi *.gif *.jpg *.tiff *.Z *.tar core}
		{j:alert -text "I don't know how to edit this kind of file."}
      {*.obj}
		{exec tgif $i &}
      {default}
		{exec jedit $i &}

      }
    } else {
      j:alert -text "`$i' is a directory."
    }
  }
}

######################################################################
# jbr:cmd:print - send a file to the printer
######################################################################

proc jbr:cmd:print {} {
  foreach i [getfiles] {
    if {![file isdirectory $i]} {
      case $i in {

      {browser-test}
	{j:alert -text {Yup, you're using your own ticklish script.}}
      {*.c *.h *.f *.tk}
	{exec enscript -2rGh $i &}
      {*.dvi}
	{exec dvips $i &}
      {*.tex}
	{j:alert -text "Process this file, and then print the .dvi file."}
      {*.latex}
	{j:alert -text "Process this file, and then print the .dvi file."}
      {*.Z *.tar}
	{j:alert -text "This file can't be printed without further processing."}
      {core}
	{j:alert -text "You don't really want to print a core file, do you?"}
      {*.dvi *.gif *.jpg *.tiff *.xbm *.bdf *.p?m}
	{j:alert -text "I don't know how to print this kind of file."}
      {*.obj}
	{j:alert -text "Print this file from within TGIF."}
      {default}
	{lpr $i &}

      }
    } else {
      j:alert -text "`$i' is a directory."
    }
  }
}

######################################################################
# jbr:cmd:process - compile or otherwise process a file
######################################################################

# counter-intuitive to launch files here, but...
# maybe should put in generalised executable-launching mechanism
# how do you check whether an executable is an X app?  use nm?
# is nm portable?

# add:
#	troff

proc jbr:cmd:process {} {
  foreach i [getfiles] {
    if {![file isdirectory $i]} {
      case $i in {

      {browser-test}
	{j:alert -text {Yup, you're using your own ticklish script.}}
      {[mM]akefile*}
		{jbr:more {Output of `make'} [exec make -f $i]}
      {Imakefile}
		{jbr:more {Output of `xmkmf'} [exec xmkmf]}
      {*.c}
		{jbr:more {Output of `cc'} [exec cc -o [file rootname $i] $i]}
      {*.tex}
		{jbr:more {Output of `tex'} [exec tex $i < /dev/null]}
      {*.latex}
		{jbr:more {Output of `latex'} [exec latex $i < /dev/null]}
      {*.Z}
		{exec zcat $i > [file rootname $i]; jbr:fill_browser}
      {*.tar}
		{jbr:more "Output of `tar xvf $i'" [exec tar xvf $i]}
      {*.shar}
		{jbr:more {Output of `sh'} [exec sh $i]}
      {*.uu *.uud}
		{exec uudecode $i; jbr:fill_browser}
      {*.tk}
		{exec $i}
      {*.obj}
		{j:alert -text "I can't process this file."}
      {default}
		{j:alert -text "I don't know what to do with this file."}

      }
    } else {
      j:alert -text "`$i' is a directory."
    }
  }
}
