/*
@(#)  FILE: tv_util.h  RELEASE: 1.1  DATE: 5/20/94, 12:06:46
*/
/*******************************************************************************

  tv_util.h

  "timeval" Manipulation Definitions.

*******************************************************************************/

#ifndef  TV_UTIL_H			/* Has the file been INCLUDE'd already? */
#define  TV_UTIL_H  yes


#if defined(VMS)
#    include  <socket.h>		/* VMS "timeval" definitions. */
#elif defined(VXWORKS)
#    include  <sys/times.h>		/* System time definitions. */
#else
#    include  <sys/time.h>		/* System time definitions. */
#endif


#ifndef P_
#    if __STDC__ || defined(__cplusplus) || defined(vaxc)
#        define  P_(s)  s
#    else
#        define  P_(s)  ()
#        define  const
#    endif
#endif


/*******************************************************************************
    Public functions.
*******************************************************************************/

extern  struct  timeval tv_add P_((struct timeval time_1,
                                   struct timeval time_2)) ;

extern  int  tv_compare P_((struct timeval time_1,
                            struct timeval time_2)) ;

extern  struct  timeval  tv_create P_((long seconds,
                                       long microseconds)) ;

extern  struct  timeval  tv_create_f P_((double f_seconds)) ;

extern  char  *tv_display P_((struct timeval binary_time)) ;

extern  double  tv_float P_((struct timeval time)) ;

extern  struct  timeval  tv_subtract P_((struct timeval time_1,
                                         struct timeval time_2)) ;

extern  struct  timeval  tv_tod P_((void)) ;


#endif				/* If this file was not INCLUDE'd previously. */
