#!/usr/bin/X11/wish -f

# *********************************************************************
# Simple Wish script for communicating with Lisp
# Note: this assumes readlns.awk is in the current directory.
# Jonathan Kaye, kaye@linc.cis.upenn.edu, August 1991
# *********************************************************************

# sendlisp
# Sends a character to Lisp then waits for a response

proc sendlisp char {
	puts stdout $char
	flush stdout
	foreach i [exec awk -f readlns.awk] \
			{eval $i}
	}

# telllisp
# Sends characters to Lisp without waiting for a response

proc telllisp char {
        puts stdout $char
        }

# TELLUSER ##############################################################
# Put up a window giving the user some information.  The user removes the
# window by pressing Return within the window.

proc telluser {windname text} {

	# Make sure message isn't already shown!
	set w $windname
	catch {destroy $w}

	toplevel $w -bd 1 -relief raised

	message $w.msg -text $text \
                       -justify center \
		       -border 2 \
		       -relief raised \
                       -font *times-medium-r-normal--*-180*

	pack append $w  $w.msg {top fill} \
			[message $w.kill \
			    -justify center \
	                    -font *times-medium-r-normal--*-120* -aspect 400 \
 			    -text "Press <Return> to remove"] bottom

	bind $w <Return> "destroy $w"
}


proc mainwind {} {

	frame .buts -border 1
	message .msg -text {I just want to say something}
	pack append .buts \
		[button .buts.1 -text {Build Window} \
			-command {sendlisp buildproc}] {top expand fill} \
		[button .buts.2 -text {Display message} \
			-command {sendlisp dispmsg}] {top expand fill} \
		[button .buts.3 -text {Change message} \
			-command {sendlisp chgmsg}] {top expand fill} \
		[button .buts.4 -text {Quit} \
			-command {sendlisp exit; destroy .}] {top expand fill}
	pack append . .msg {top expand fill} .buts {top expand fill}
}

#########################################################################
### MAIN WINDOW

mainwind

# Wait for Lisp to send something before starting

foreach i [exec awk -f readlns.awk] \
	{eval $i}
