/* 
 * Copyright (c) 1994 Open Software Foundation, Inc.
 * 
 * Permission is hereby granted to use, copy, modify and freely distribute
 * the software in this file and its documentation for any purpose without
 * fee, provided that the above copyright notice appears in all copies, and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.  Further, provided that the name of Open
 * Software Foundation, Inc. ("OSF") not be used in advertising or
 * publicity pertaining to distribution of the software without prior
 * written permission from OSF.  OSF makes no representations about the
 * suitability of this software for any purpose.  It is provided "AS IS"
 * without express or implied warranty.
 */ 

/* otSplitHeadHistFile.c
 *
 * Split the file generated by the otCreateHeadHistFile into two database
 * files "headdb" and "histdb" for the project
 *
 * otSplitHeadHistFile  [-p<proj>] [file]
 *
 * where:
 *	[-p<proj>]  - OT projectname
 *      [file]      - input file (default is /project/ot/<proj>/HeadAndHist)
 *
 * note:
 */

#define MAINPROGRAM

#include <string.h>
#include <ctype.h>
#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <pwd.h>
#include <tcl.h>
#include <tclInt.h>
#include "ot.h"
#include "otInt.h"

#ifndef LINT
static char RCSid_otSplitHeadHistFile[] = 
    "$RCSfile: otSplitHeadHistFile.c,v $ $Revision: 1.1.5.2 $ $Date: 1993/09/28 17:36:05 $";
#endif

/* command line options for getopt() */
#define optString "p:"

OTErr	splParseArgs();
OTErr	splProcessFile();



/*
 *			m a i n
 *
 */

main(argc, argv, envp)
int argc;
char ** argv;
char ** envp;
{
    char    tmp[COMMAND];
    char    tmp1[COMMAND];
    char    path[PATHLEN];
    struct  stat stat_buf;
    OTErr   err;
    OTProject   *prjp;

    /*
     * Initialize TCL, control blocks, read environment variables and
     * preparse command line for project and template file names 
     */
    if ( err = otInitialInit(&argc, argv) ) {
	fprintf(stderr, "otInitialInit: %s\n", otGetPostedMessage() );
	exit(1);
    }

    if ( err = splParseArgs(argc, argv) ) {
	fprintf(stderr, "hhfParseArgs: %s\n", otGetPostedMessage() );
	exit(1);
    }

    if ( err = otReadProject( otCB->cb_project ) ) {
	fprintf(stderr, "otReadProject: %s\n", otGetPostedMessage() );
	exit(1);
    }

    prjp = otCB->cb_pcb->pcb_project;
    sprintf(path, "%s/%s", prjp->proj_dir, prjp->name);

    if (!otCB->cb_templFile) {		/* use default file */

	sprintf(tmp, "%s/HeadAndHist", path);

	if ( !(err = otSetCBMember("templFile", tmp)) ) {
	    if (stat(tmp, &stat_buf) != 0) {
	        otPutPostedMessage(OT_STAT, tmp);
	        err = OT_STAT;
	    }
	    else if (!(stat_buf.st_mode & S_IFREG)) {
	        otPutPostedMessage(OT_NOT_REGULAR_FILE, tmp);
	        err = OT_NOT_REGULAR_FILE;
	    }
	}
	if (err) {
	    fprintf(stderr, "main: %s\n", otGetPostedMessage() );
	    exit(1);
	}
    }

    sprintf(tmp, "%s/%s", path, HEADERDB);

    if (stat(tmp, &stat_buf) == 0) {
	sprintf(tmp1, "file '%s' already exist", tmp);
	otPutPostedMessage(OT_GENERAL_ERROR, tmp1);
	err = OT_GENERAL_ERROR;
    }

    sprintf(tmp, "%s/%s", path, HISTORYDB);

    if (stat(tmp, &stat_buf) == 0)  {
	sprintf(tmp1, "file '%s' already exist", tmp);
	otPutPostedMessage(OT_GENERAL_ERROR, tmp1);
	err = OT_GENERAL_ERROR;
    }

    if (err) {
	fprintf(stderr, "main: %s\n", otGetPostedMessage() );
	exit(1);
    }

    if (err = splProcessFile()) {
	fprintf(stderr, "splProcessFile: %s\n", otGetPostedMessage() );
	exit(1);
    }

    exit(0);
}



OTErr
splProcessFile()
{
    register int ch;
    char    path[PATHLEN];
    char    tmp[COMMAND];
    FILE   *hhfp;
    FILE   *hdrfp;
    FILE   *hstfp;
    OTProject *prjp;

    OTErr   err = OT_SUCCESS;

    prjp = otCB->cb_pcb->pcb_project;

    sprintf(path, "%s/%s", prjp->proj_dir, prjp->name);
    
    /* open HeadAndHist input file and both "headdb" and "histdb" ouput files */

    if ( (hhfp = fopen(otCB->cb_templFile, "r")) == NULL) {
        otPutPostedMessage(OT_FILE_OPEN, otCB->cb_templFile, "splProcessFile");
	return OT_FILE_OPEN;
    }

    sprintf(tmp, "%s/%s", path, HEADERDB);

    if ( (hdrfp = fopen(tmp, "w")) == NULL) {
	otPutPostedMessage(OT_CREATE_FILE, "header DB", tmp);
	fclose(hhfp);
	return OT_CREATE_FILE;
    }

    sprintf(tmp, "%s/%s", path, HISTORYDB);

    if ( (hstfp = fopen(tmp, "w")) == NULL) {
	otPutPostedMessage(OT_CREATE_FILE, "history DB", tmp);
	fclose(hhfp);
	fclose(hdrfp);
	return OT_CREATE_FILE;
    }

    while (TRUE) {

	/* put the headdb line */

	while ( ((ch=fgetc(hhfp)) != EOF) && (ch != '\n') )
	    fputc(ch, hdrfp);
	if (ch == '\n')
	    fputc('\n', hdrfp);
	else 
	    break;
	
	/* put the histdb line */

	while ( ((ch=fgetc(hhfp)) != EOF) && (ch != '\n') )
	    fputc(ch, hstfp);
	if (ch == '\n')
	    fputc('\n', hstfp);
	if (ch == EOF)
	    break;
    }

    fclose(hhfp);
    fclose(hdrfp);
    fclose(hstfp);

    return err;
}



OTErr
splParseArgs(argc, argv)
int argc;
char * argv[];
{
    register int  i, opt;
    char tmp[COMMAND];
    struct stat stat_buf;

    OTErr errCode = OT_SUCCESS;

    while ( (opt = getopt(argc, argv, optString)) != EOF )  {
	switch ( opt )  {

	case 'p':
	    otPutPostedMessage(OT_INTERNAL_ERROR,
			"otPreparseInput while extracting OT projectname");
	    errCode = OT_INTERNAL_ERROR;
	    break;

	case '?':
	    otPutPostedMessage(OT_GENERAL_ERROR, 
		"usage:  otSplitHeadFile [-p<projectname>] [headhistfile]");
	    errCode = OT_GENERAL_ERROR;
	    break;
	}
    }

    for (i=optind;  (i < argc) && !errCode;  i++)    {
	if (otCB->cb_templFile) {
	    errCode = OT_ONE_FILENAME_ONLY;
	    otPutPostedMessage(OT_ONE_FILENAME_ONLY, optarg);
	}
	else {

	    if ( !(errCode = otSetCBMember("templFile", argv[i])) )  {
	        if (stat(otCB->cb_templFile, &stat_buf) != 0) {
		    errCode = OT_STAT;
		    otPutPostedMessage(OT_STAT, otCB->cb_templFile);
		}
		else if (!(stat_buf.st_mode & S_IFREG)) {
		    errCode = OT_NOT_REGULAR_FILE;
		    otPutPostedMessage(OT_NOT_REGULAR_FILE, otCB->cb_templFile);
		}
	    }
	}
    }

    return errCode;
}


